/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy;

import java.lang.management.ManagementFactory;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import org.ibboost.orqa.automation.java.common.RMILoopbackSocketFactory;
import org.ibboost.orqa.automation.java.proxy.AttachCallback;
import org.ibboost.orqa.automation.java.proxy.ProxyAgent;

public class AttachCallbackImpl
extends UnicastRemoteObject
implements AttachCallback {
    private static final long serialVersionUID = -4094470783200662240L;
    private static final RMILoopbackSocketFactory socketFactory = new RMILoopbackSocketFactory();
    private final boolean succeeded;
    private final Throwable error;
    private final String failureReason;

    public AttachCallbackImpl(boolean succeeded, String failureReason, Throwable error) throws RemoteException {
        super(0, socketFactory, socketFactory);
        this.succeeded = succeeded;
        this.failureReason = failureReason;
        this.error = error;
    }

    @Override
    public boolean getAttachSucceeded() throws RemoteException {
        return this.succeeded;
    }

    @Override
    public List<String> getWindowNames() throws RemoteException {
        return ProxyAgent.getWindowNames();
    }

    @Override
    public String getAttachFailureReason() throws RemoteException {
        return this.failureReason;
    }

    @Override
    public String getCommandLine() throws RemoteException {
        List<String> jvmArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        String command = "";
        for (String jvmArg : jvmArgs) {
            if (jvmArg.contains(" ")) {
                jvmArg = "\"" + jvmArg;
            }
            command = command + jvmArg;
        }
        String classPath = System.getProperty("java.class.path");
        if (classPath.contains(" ")) {
            classPath = "\"" + classPath + "\"";
        }
        command = command + " -classpath " + System.getProperty("java.class.path");
        command = command + " " + System.getProperty("sun.java.command");
        return command;
    }

    @Override
    public String getWorkingDir() throws RemoteException {
        return System.getProperty("user.dir");
    }

    @Override
    public String getJavaHome() throws RemoteException {
        return System.getProperties().getProperty("java.home");
    }

    @Override
    public Throwable getError() throws RemoteException {
        return this.error;
    }
}

