/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;

public class ArgumentUtils {
    public static HashMap<String, String> parseArgs(String[] args) {
        HashMap<String, String> argMap = new HashMap<String, String>();
        for (String arg : args) {
            int valueIndex = arg.indexOf(61);
            if (valueIndex > 0) {
                argMap.put(arg.substring(0, valueIndex), arg.substring(valueIndex + 1));
                continue;
            }
            argMap.put(arg, null);
        }
        return argMap;
    }

    public static String encodeArgs(Map<String, String> arguments) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : arguments.entrySet()) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(entry.getKey());
            if (entry.getValue() == null) continue;
            try {
                result.append("=");
                if (entry.getValue().isEmpty()) continue;
                result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                RemoteLogger.error(e);
            }
        }
        return result.toString();
    }

    public static Map<String, String> decodeArgs(String arguments) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String entry : arguments.split(",")) {
            String value;
            int seperatorIndex = entry.indexOf("=");
            String key = seperatorIndex > -1 ? entry.substring(0, seperatorIndex) : entry;
            String string = value = seperatorIndex > -1 ? entry.substring(seperatorIndex + 1) : null;
            if (value != null && !value.trim().isEmpty()) {
                try {
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    RemoteLogger.error(e);
                }
            }
            result.put(key, value);
        }
        return result;
    }
}

