/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.common;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.ibboost.orqa.automation.java.common.RMILoopbackSocketFactory;

public class RmiRegistryController {
    private final RMILoopbackSocketFactory socketFactory;
    private final Registry registry;
    private Integer registryPort;

    public RmiRegistryController() throws RemoteException {
        System.setProperty("java.rmi.server.hostname", "127.0.0.1");
        this.socketFactory = new RMILoopbackSocketFactory(){

            @Override
            public ServerSocket createServerSocket(int port) throws IOException {
                ServerSocket socket = super.createServerSocket(port);
                RmiRegistryController.this.registryPort = socket.getLocalPort();
                return socket;
            }
        };
        this.registry = LocateRegistry.createRegistry(0, this.socketFactory, this.socketFactory);
    }

    public void stopRMIRegistry() {
        try {
            String[] stringArray = this.registry.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String binding = stringArray[n2];
                Naming.unbind(RmiRegistryController.getBindingUrl(binding, this.registryPort));
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            UnicastRemoteObject.unexportObject(this.registry, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socketFactory.closeAllOpenSockets();
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    private static String getBindingUrl(String bindingName, int port) {
        return "rmi://localhost:" + port + "/" + bindingName;
    }

    public static void bind(String bindingName, int bindingPort, Remote remote) throws RemoteException, MalformedURLException {
        Naming.rebind(RmiRegistryController.getBindingUrl(bindingName, bindingPort), remote);
    }

    public static Remote lookup(String bindingName, int bindingPort) throws RemoteException, MalformedURLException, NotBoundException {
        return Naming.lookup(RmiRegistryController.getBindingUrl(bindingName, bindingPort));
    }

    public static void unbind(String bindingName, int bindingPort) throws RemoteException, MalformedURLException, NotBoundException {
        Naming.unbind(RmiRegistryController.getBindingUrl(bindingName, bindingPort));
    }
}

