/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.common;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class ProxySystemClassLoader
extends URLClassLoader {
    public static final String WRAPPED_SYSTEM_CLASSLOADER_PROPERTY = "javaProxyWrappedSystemClassLoader";
    private final ClassLoader defaultParent;

    public ProxySystemClassLoader() {
        this((ClassLoader)null);
    }

    public ProxySystemClassLoader(ClassLoader defaultParent) {
        super(new URL[0], ProxySystemClassLoader.getParent(defaultParent));
        this.defaultParent = defaultParent;
    }

    private static ClassLoader getParent(ClassLoader defaultParent) {
        String wrappedClassLoader = System.getProperty(WRAPPED_SYSTEM_CLASSLOADER_PROPERTY);
        if (wrappedClassLoader != null && !wrappedClassLoader.isEmpty()) {
            try {
                Class<?> wrappedClassLoaderClass = defaultParent.loadClass(wrappedClassLoader);
                Constructor<?> constructor = wrappedClassLoaderClass.getDeclaredConstructor(ClassLoader.class);
                return (ClassLoader)constructor.newInstance(defaultParent);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return defaultParent;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (this.defaultParent != this.getParent()) {
                return this.defaultParent.loadClass(name);
            }
            throw e;
        }
    }

    public void appendToClassPathForInstrumentation(String path) {
        try {
            this.addURL(new File(path).toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

