/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.common;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.ibboost.orqa.automation.java.common.JavaAppException;

public class OperationTimeoutException
extends JavaAppException {
    private static final long serialVersionUID = 1L;
    private final String threadDump = OperationTimeoutException.captureThreadDump();

    public OperationTimeoutException() {
        super(new Exception("The operation took too long to complete"));
    }

    public String getThreadDump() {
        return this.threadDump;
    }

    private static synchronized String captureThreadDump() {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threads = threadBean.getThreadInfo(threadBean.getAllThreadIds(), 100);
        String newLine = System.getProperty("line.separator", "\n");
        StringBuilder threadDump = new StringBuilder();
        ThreadInfo[] threadInfoArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo thread = threadInfoArray[n2];
            threadDump.append('\"').append(thread.getThreadName()).append('\"').append(newLine).append("\t").append(Thread.State.class.getName()).append(": '").append((Object)thread.getThreadState()).append("'").append(newLine);
            StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
            int n3 = stackTraceElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n4];
                threadDump.append("\t\tat ").append(stackTraceElement).append(newLine);
                ++n4;
            }
            threadDump.append(newLine).append(newLine);
            ++n2;
        }
        return threadDump.toString();
    }
}

