/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class JavaProcessOutputConsumer {
    private final CountDownLatch applicationTerminationLatch = new CountDownLatch(1);
    private final StringBuilder stdErr = new StringBuilder();
    private final StringBuilder stdOut = new StringBuilder();
    private final StringBuilder combinedOut = new StringBuilder();
    private final Process process;
    private final BufferedReader processErr;
    private final BufferedReader processOut;
    private String errorMessage;

    public JavaProcessOutputConsumer(Process process, final boolean storeOutput, final boolean outputToConsole) {
        this.process = process;
        this.processErr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        this.processOut = new BufferedReader(new InputStreamReader(process.getInputStream()));
        final Thread sysErrThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean javaToolOptionsLineSeen = false;
                    String processError = null;
                    while ((processError = JavaProcessOutputConsumer.this.processErr.readLine()) != null) {
                        if (!javaToolOptionsLineSeen && processError.contains("JAVA_TOOL_OPTIONS:")) {
                            javaToolOptionsLineSeen = true;
                            continue;
                        }
                        if (JavaProcessOutputConsumer.this.errorMessage == null) {
                            JavaProcessOutputConsumer.this.errorMessage = processError;
                        }
                        if (storeOutput) {
                            JavaProcessOutputConsumer.this.stdErr.append(processError).append("\r\n");
                            StringBuilder stringBuilder = JavaProcessOutputConsumer.this.combinedOut;
                            synchronized (stringBuilder) {
                                JavaProcessOutputConsumer.this.combinedOut.append(processError).append("\r\n");
                            }
                        }
                        if (!outputToConsole) continue;
                        System.err.println(processError);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        sysErrThread.start();
        Thread sysOutThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        String processOutput = null;
                        while ((processOutput = JavaProcessOutputConsumer.this.processOut.readLine()) != null) {
                            if (storeOutput) {
                                JavaProcessOutputConsumer.this.stdOut.append(processOutput).append("\r\n");
                                StringBuilder stringBuilder = JavaProcessOutputConsumer.this.combinedOut;
                                synchronized (stringBuilder) {
                                    JavaProcessOutputConsumer.this.combinedOut.append(processOutput).append("\r\n");
                                }
                            }
                            if (!outputToConsole) continue;
                            System.out.println(processOutput);
                        }
                    }
                    catch (IOException iOException) {
                        JavaProcessOutputConsumer.this.applicationTerminationLatch.countDown();
                        try {
                            sysErrThread.join();
                            JavaProcessOutputConsumer.this.processOut.close();
                            JavaProcessOutputConsumer.this.processErr.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    JavaProcessOutputConsumer.this.applicationTerminationLatch.countDown();
                    try {
                        sysErrThread.join();
                        JavaProcessOutputConsumer.this.processOut.close();
                        JavaProcessOutputConsumer.this.processErr.close();
                    }
                    catch (Exception exception) {}
                }
            }
        };
        sysOutThread.start();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getStdOut() {
        return this.stdOut.toString();
    }

    public String getStdErr() {
        return this.stdErr.toString();
    }

    public String getCombinedOut() {
        return this.combinedOut.toString();
    }

    public void awaitApplicationTermination(int timeout) throws InterruptedException {
        if (!this.applicationTerminationLatch.await(timeout, TimeUnit.MILLISECONDS)) {
            this.process.destroy();
        }
    }

    public void awaitApplicationTermination() throws InterruptedException {
        this.applicationTerminationLatch.await();
    }

    public void close() {
        new Thread(){

            @Override
            public void run() {
                try {
                    JavaProcessOutputConsumer.this.processOut.close();
                    JavaProcessOutputConsumer.this.processErr.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }
}

