/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.utils;

import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.FnData;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import java.util.Collection;
import java.util.Iterator;

public abstract class TypePromoter {
    private Class targetType = null;

    public abstract AnyAtomicType doPromote(AnyAtomicType var1) throws DynamicError;

    public final AnyAtomicType promote(AnyType value) throws DynamicError {
        if (value.getClass() == this.getTargetType()) {
            return (AnyAtomicType)value;
        }
        AnyAtomicType atomized = FnData.atomize(value);
        if (atomized == null) {
            return null;
        }
        return this.doPromote(atomized);
    }

    protected abstract Class substitute(Class var1);

    protected abstract boolean checkCombination(Class var1);

    public void considerType(Class typeToConsider) throws DynamicError {
        Class baseType = this.substitute(typeToConsider);
        if (baseType == null) {
            throw DynamicError.argument_type_error(typeToConsider);
        }
        if (this.targetType == null) {
            this.targetType = baseType;
        } else if (!this.checkCombination(baseType)) {
            throw DynamicError.argument_type_error(typeToConsider);
        }
    }

    public void considerTypes(Collection typesToConsider) throws DynamicError {
        Iterator iter = typesToConsider.iterator();
        while (iter.hasNext()) {
            this.considerType((Class)iter.next());
        }
    }

    public void considerSequence(ResultSequence sequenceToConsider) throws DynamicError {
        for (int i = 0; i < sequenceToConsider.size(); ++i) {
            Item item = sequenceToConsider.item(i);
            this.considerValue(item);
        }
    }

    public Class getTargetType() {
        return this.targetType;
    }

    protected void setTargetType(Class class1) {
        this.targetType = class1;
    }

    public void considerValue(Item at) throws DynamicError {
        AnyAtomicType atomize = FnData.atomize(at);
        if (atomize != null) {
            this.considerType(atomize.getClass());
        }
    }
}

