/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.utils;

import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.XSDate;
import info.fingo.xactus.processor.internal.types.XSDateTime;
import info.fingo.xactus.processor.internal.types.XSDayTimeDuration;
import info.fingo.xactus.processor.internal.types.XSYearMonthDuration;
import info.fingo.xactus.processor.internal.utils.NumericTypePromoter;

public class ScalarTypePromoter
extends NumericTypePromoter {
    @Override
    protected boolean checkCombination(Class newType) {
        Class targetType = this.getTargetType();
        if (targetType == XSDayTimeDuration.class || targetType == XSYearMonthDuration.class) {
            return targetType == newType;
        }
        if (newType == XSDate.class) {
            return targetType == XSDate.class;
        }
        if (newType == XSDateTime.class) {
            return targetType == XSDateTime.class;
        }
        return super.checkCombination(newType);
    }

    @Override
    public AnyAtomicType doPromote(AnyAtomicType value) throws DynamicError {
        if (this.getTargetType() == XSDate.class) {
            return XSDate.parse_date(value.getStringValue());
        }
        if (this.getTargetType() == XSDateTime.class) {
            return XSDateTime.parseDateTime(value.getStringValue());
        }
        if (this.getTargetType() == XSYearMonthDuration.class) {
            return XSYearMonthDuration.parseYMDuration(value.getStringValue());
        }
        if (this.getTargetType() == XSDayTimeDuration.class) {
            return XSDayTimeDuration.parseDTDuration(value.getStringValue());
        }
        return super.doPromote(value);
    }

    @Override
    protected Class substitute(Class typeToConsider) {
        if (typeToConsider == XSDayTimeDuration.class || typeToConsider == XSYearMonthDuration.class) {
            return typeToConsider;
        }
        return super.substitute(typeToConsider);
    }
}

