/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.CmpEq;
import info.fingo.xactus.processor.internal.function.CmpGt;
import info.fingo.xactus.processor.internal.function.CmpLt;
import info.fingo.xactus.processor.internal.function.MathDiv;
import info.fingo.xactus.processor.internal.function.MathMinus;
import info.fingo.xactus.processor.internal.function.MathPlus;
import info.fingo.xactus.processor.internal.function.MathTimes;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.CalendarType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.XSAnyURI;
import info.fingo.xactus.processor.internal.types.XSBase64Binary;
import info.fingo.xactus.processor.internal.types.XSBoolean;
import info.fingo.xactus.processor.internal.types.XSDayTimeDuration;
import info.fingo.xactus.processor.internal.types.XSDecimal;
import info.fingo.xactus.processor.internal.types.XSDouble;
import info.fingo.xactus.processor.internal.types.XSDuration;
import info.fingo.xactus.processor.internal.types.XSHexBinary;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.math.BigDecimal;

public class XSYearMonthDuration
extends XSDuration
implements CmpEq,
CmpLt,
CmpGt,
MathPlus,
MathMinus,
MathTimes,
MathDiv {
    private static final String XS_YEAR_MONTH_DURATION = "xs:yearMonthDuration";

    public XSYearMonthDuration(int year, int month, boolean negative) {
        super(year, month, 0, 0, 0, 0.0, negative);
    }

    public XSYearMonthDuration(int months) {
        this(0, Math.abs(months), months < 0);
    }

    public XSYearMonthDuration() {
        this(0, 0, false);
    }

    public static XSDuration parseYMDuration(String str) {
        boolean negative = false;
        int year = 0;
        int month = 0;
        int state = 0;
        String digits = "";
        block7: for (int i = 0; i < str.length(); ++i) {
            char x = str.charAt(i);
            switch (state) {
                case 0: {
                    if (x == '-') {
                        negative = true;
                        state = 4;
                        continue block7;
                    }
                    if (x == 'P') {
                        state = 5;
                        continue block7;
                    }
                    return null;
                }
                case 4: {
                    if (x == 'P') {
                        state = 5;
                        continue block7;
                    }
                    return null;
                }
                case 5: {
                    if ('0' <= x && x <= '9') {
                        digits = digits + x;
                        continue block7;
                    }
                    if (x == 'Y') {
                        if (digits.length() == 0) {
                            return null;
                        }
                        year = Integer.parseInt(digits);
                        digits = "";
                        state = 6;
                        continue block7;
                    }
                    if (x == 'M') {
                        if (digits.length() == 0) {
                            return null;
                        }
                        month = Integer.parseInt(digits);
                        state = 7;
                        continue block7;
                    }
                    return null;
                }
                case 6: {
                    if ('0' <= x && x <= '9') {
                        digits = digits + x;
                        continue block7;
                    }
                    if (x == 'M') {
                        if (digits.length() == 0) {
                            return null;
                        }
                        month = Integer.parseInt(digits);
                        state = 7;
                        continue block7;
                    }
                    return null;
                }
                case 7: {
                    return null;
                }
                default: {
                    assert (false);
                    return null;
                }
            }
        }
        return new XSYearMonthDuration(year, month, negative);
    }

    @Override
    public String type_name() {
        return "yearMonthDuration";
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        if (aat instanceof NumericType || aat instanceof CalendarType || aat instanceof XSBoolean || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        XSDuration ymd = this.castYearMonthDuration(aat);
        if (ymd == null) {
            throw DynamicError.cant_cast(null);
        }
        return ymd;
    }

    private XSDuration castYearMonthDuration(AnyAtomicType aat) {
        if (aat instanceof XSDuration) {
            XSDuration duration = (XSDuration)aat;
            return new XSYearMonthDuration(duration.year(), duration.month(), duration.negative());
        }
        return XSYearMonthDuration.parseYMDuration(aat.getStringValue());
    }

    @Override
    public boolean negative() {
        return this._negative;
    }

    @Override
    public String getStringValue() {
        int months;
        String strval = "";
        if (this.negative()) {
            strval = strval + "-";
        }
        strval = strval + "P";
        int years = this.year();
        if (years != 0) {
            strval = strval + years + "Y";
        }
        if ((months = this.month()) == 0) {
            if (years == 0) {
                strval = strval + months + "M";
            }
        } else {
            strval = strval + months + "M";
        }
        return strval;
    }

    @Override
    public String string_type() {
        return XS_YEAR_MONTH_DURATION;
    }

    public int monthValue() {
        int ret = this.year() * 12 + this.month();
        if (this.negative()) {
            ret *= -1;
        }
        return ret;
    }

    @Override
    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        if (arg instanceof XSDayTimeDuration) {
            XSDayTimeDuration dayTimeDuration = (XSDayTimeDuration)arg;
            return this.monthValue() == 0 && dayTimeDuration.value() == 0.0;
        }
        if (arg instanceof XSYearMonthDuration) {
            XSYearMonthDuration yearMonthDuration = (XSYearMonthDuration)arg;
            return this.monthValue() == yearMonthDuration.monthValue();
        }
        XSDuration val = (XSDuration)NumericType.get_single_type(arg, XSDuration.class);
        return super.eq(val, dynamicContext);
    }

    @Override
    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        XSYearMonthDuration val = (XSYearMonthDuration)NumericType.get_single_type(arg, XSYearMonthDuration.class);
        return this.monthValue() < val.monthValue();
    }

    @Override
    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        XSYearMonthDuration val = (XSYearMonthDuration)NumericType.get_single_type(arg, XSYearMonthDuration.class);
        return this.monthValue() > val.monthValue();
    }

    @Override
    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        XSYearMonthDuration val = (XSYearMonthDuration)NumericType.get_single_type(arg, XSYearMonthDuration.class);
        int res = this.monthValue() + val.monthValue();
        return new XSYearMonthDuration(res);
    }

    @Override
    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        XSYearMonthDuration val = (XSYearMonthDuration)NumericType.get_single_type(arg, XSYearMonthDuration.class);
        int res = this.monthValue() - val.monthValue();
        return new XSYearMonthDuration(res);
    }

    @Override
    public ResultSequence times(ResultSequence arg) throws DynamicError {
        XSDouble val;
        Item argValue;
        ResultSequence convertedRS = arg;
        if (arg.size() == 1 && (argValue = arg.first()) instanceof XSDecimal) {
            convertedRS = new XSDouble(argValue.getStringValue());
        }
        if ((val = (XSDouble)NumericType.get_single_type(convertedRS, XSDouble.class)).nan()) {
            throw DynamicError.nan();
        }
        if (val.infinite()) {
            throw DynamicError.overflowDateTime();
        }
        int res = (int)Math.round((double)this.monthValue() * val.double_value());
        return new XSYearMonthDuration(res);
    }

    @Override
    public ResultSequence div(ResultSequence arg) throws DynamicError {
        Item at;
        if (arg.size() != 1) {
            DynamicError.throw_type_error();
        }
        if ((at = arg.first()) instanceof XSDouble) {
            XSDouble dt = (XSDouble)at;
            int ret = 0;
            if (!dt.zero()) {
                ret = (int)Math.round((double)this.monthValue() / dt.double_value());
            }
            return new XSYearMonthDuration(ret);
        }
        if (at instanceof XSDecimal) {
            XSDecimal dt = (XSDecimal)at;
            int ret = 0;
            if (!dt.zero()) {
                ret = (int)Math.round((double)this.monthValue() / dt.getValue().doubleValue());
            }
            return new XSYearMonthDuration(ret);
        }
        if (at instanceof XSYearMonthDuration) {
            XSYearMonthDuration md = (XSYearMonthDuration)at;
            double res = (double)this.monthValue() / (double)md.monthValue();
            return new XSDecimal(new BigDecimal(res));
        }
        DynamicError.throw_type_error();
        return null;
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_YEARMONTHDURATION;
    }
}

