/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.types.XSNonPositiveInteger;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.math.BigInteger;

public class XSNegativeInteger
extends XSNonPositiveInteger {
    private static final String XS_NEGATIVE_INTEGER = "xs:negativeInteger";

    public XSNegativeInteger() {
        this(BigInteger.valueOf(-1L));
    }

    public XSNegativeInteger(BigInteger x) {
        super(x);
    }

    @Override
    public String string_type() {
        return XS_NEGATIVE_INTEGER;
    }

    @Override
    public String type_name() {
        return "negativeInteger";
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.getStringValue());
            BigInteger max = BigInteger.valueOf(-1L);
            if (bigInt.compareTo(max) > 0) {
                throw DynamicError.cant_cast(null);
            }
            return new XSNegativeInteger(bigInt);
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null);
        }
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_NEGATIVEINTEGER;
    }
}

