/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.CalendarType;
import info.fingo.xactus.processor.internal.types.NodeType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.XSAnyURI;
import info.fingo.xactus.processor.internal.types.XSBase64Binary;
import info.fingo.xactus.processor.internal.types.XSBoolean;
import info.fingo.xactus.processor.internal.types.XSDecimal;
import info.fingo.xactus.processor.internal.types.XSDouble;
import info.fingo.xactus.processor.internal.types.XSDuration;
import info.fingo.xactus.processor.internal.types.XSFloat;
import info.fingo.xactus.processor.internal.types.XSHexBinary;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.types.XSUntypedAtomic;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.math.BigDecimal;
import java.math.BigInteger;

public class XSInteger
extends XSDecimal {
    private static final String XS_INTEGER = "xs:integer";
    private BigInteger _value;

    public XSInteger() {
        this(BigInteger.valueOf(0L));
    }

    public XSInteger(BigInteger x) {
        super(new BigDecimal(x));
        this._value = x;
    }

    public XSInteger(String x) {
        super(new BigDecimal(x));
        this._value = new BigInteger(x);
    }

    @Override
    public String string_type() {
        return XS_INTEGER;
    }

    @Override
    public String type_name() {
        return "integer";
    }

    @Override
    public String getStringValue() {
        return this._value.toString();
    }

    @Override
    public Number getNativeValue() {
        return this._value;
    }

    @Override
    public boolean zero() {
        return this._value.compareTo(BigInteger.ZERO) == 0;
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        if (aat instanceof XSDuration || aat instanceof CalendarType || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        try {
            BigInteger bigInt = this.castInteger(aat);
            return new XSInteger(bigInt);
        }
        catch (NumberFormatException e) {
            throw DynamicError.invalidLexicalValue();
        }
    }

    private BigInteger castInteger(Item aat) {
        if (aat instanceof XSBoolean) {
            if (aat.getStringValue().equals("true")) {
                return BigInteger.ONE;
            }
            return BigInteger.ZERO;
        }
        if (aat instanceof XSDecimal || aat instanceof XSFloat || aat instanceof XSDouble) {
            BigDecimal bigDec = new BigDecimal(aat.getStringValue());
            return bigDec.toBigInteger();
        }
        return new BigInteger(aat.getStringValue());
    }

    private boolean isCastable(Item aat) throws DynamicError {
        if (aat instanceof XSString || aat instanceof XSUntypedAtomic || aat instanceof NodeType) {
            return this.isLexicalValue(aat.getStringValue());
        }
        return aat instanceof XSBoolean || aat instanceof NumericType;
    }

    @Override
    protected boolean isLexicalValue(String value) {
        try {
            new BigInteger(value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public BigInteger int_value() {
        return this._value;
    }

    public void set_int(BigInteger x) {
        this._value = x;
        this.set_double(x.intValue());
    }

    @Override
    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        XSDecimal val = (XSDecimal)XSInteger.get_single_type(carg, XSDecimal.class);
        BigDecimal result = val.getValue().add(new BigDecimal(this.int_value()));
        return this.createResult(result);
    }

    @Override
    protected ResultSequence convertResultSequence(ResultSequence arg) throws DynamicError {
        ResultSequence carg = arg;
        for (AnyType type : carg) {
            if (!type.string_type().equals("xs:untypedAtomic") && !type.string_type().equals("xs:string")) continue;
            throw DynamicError.invalidType();
        }
        carg = this.constructorSafe(carg);
        return carg;
    }

    @Override
    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        XSDecimal val = (XSDecimal)XSInteger.get_single_type(carg, XSDecimal.class);
        BigDecimal result = new BigDecimal(this.int_value()).subtract(val.getValue());
        return this.createResult(result);
    }

    @Override
    public ResultSequence times(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        XSDecimal val = (XSDecimal)XSInteger.get_single_type(carg, XSDecimal.class);
        return this.createResult(val.getValue().multiply(new BigDecimal(this.int_value())));
    }

    @Override
    public ResultSequence mod(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        XSDecimal val = (XSDecimal)XSInteger.get_single_type(carg, XSDecimal.class);
        if (val instanceof XSInteger) {
            BigInteger result = this.int_value().remainder(((XSInteger)val).int_value());
            return new XSInteger(result);
        }
        return super.mod(arg);
    }

    @Override
    public ResultSequence unary_minus() {
        return new XSInteger(this.int_value().multiply(BigInteger.valueOf(-1L)));
    }

    @Override
    public NumericType abs() {
        return new XSInteger(this.int_value().abs());
    }

    @Override
    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        ResultSequence rs = this.constructorSafe(arg);
        XSDecimal val = (XSDecimal)XSInteger.get_single_type(rs, XSDecimal.class);
        int compareResult = this.getValue().compareTo(val.getValue());
        return compareResult > 0;
    }

    @Override
    protected Item convertArg(AnyType arg) throws DynamicError {
        ResultSequence rs = arg;
        rs = this.constructor(rs);
        Item carg = rs.first();
        return carg;
    }

    @Override
    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        ResultSequence rs = this.constructorSafe(arg);
        XSDecimal val = (XSDecimal)XSInteger.get_single_type(rs, XSDecimal.class);
        int compareResult = this.getValue().compareTo(val.getValue());
        return compareResult < 0;
    }

    @Override
    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        ResultSequence rs = this.constructorSafe(arg);
        XSDecimal val = (XSDecimal)XSInteger.get_single_type(rs, XSDecimal.class);
        int compareResult = this.getValue().compareTo(val.getValue());
        return compareResult == 0;
    }

    @Override
    public ResultSequence div(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        XSDecimal val = (XSDecimal)XSInteger.get_single_type(carg, XSDecimal.class);
        if (val.zero()) {
            throw DynamicError.div_zero(null);
        }
        BigDecimal result = this.getValue().divide(val.getValue(), 18, 6);
        return new XSDecimal(result);
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_INTEGER;
    }

    private ResultSequence constructorSafe(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        if (aat instanceof XSDuration || aat instanceof CalendarType || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (aat.getStringValue().indexOf("-INF") != -1) {
            throw DynamicError.cant_cast(null);
        }
        if (!super.isLexicalValue(aat.getStringValue())) {
            throw DynamicError.invalidLexicalValue();
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        try {
            return this.castDecimal(aat);
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null);
        }
    }

    private ResultSequence createResult(BigDecimal result) {
        if (result.signum() == 0 || result.scale() <= 0 || result.stripTrailingZeros().scale() <= 0) {
            return new XSInteger(result.toBigInteger());
        }
        return new XSDecimal(result);
    }
}

