/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.CmpEq;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.CalendarType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.XSAnyURI;
import info.fingo.xactus.processor.internal.types.XSBase64Binary;
import info.fingo.xactus.processor.internal.types.XSBoolean;
import info.fingo.xactus.processor.internal.types.XSDate;
import info.fingo.xactus.processor.internal.types.XSDateTime;
import info.fingo.xactus.processor.internal.types.XSDuration;
import info.fingo.xactus.processor.internal.types.XSHexBinary;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.types.XSTime;
import info.fingo.xactus.processor.internal.types.XSUntypedAtomic;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class XSGYear
extends CalendarType
implements CmpEq {
    private static final String XS_G_YEAR = "xs:gYear";
    private Calendar _calendar;
    private boolean _timezoned;
    private XSDuration _tz;

    public XSGYear(Calendar cal, XSDuration tz) {
        this._calendar = cal;
        if (tz != null) {
            this._timezoned = true;
            this._tz = tz;
        }
    }

    public XSGYear() {
        this(new GregorianCalendar(TimeZone.getTimeZone("GMT")), null);
    }

    @Override
    public String type_name() {
        return "gYear";
    }

    public static XSGYear parse_gYear(String str) {
        String year = "";
        String monthDaytime = "-01-01T00:00:00.0";
        int index = str.indexOf(43, 1);
        if (index == -1) {
            index = str.indexOf(45, 1);
        }
        if (index == -1) {
            index = str.indexOf(90, 1);
        }
        if (index != -1) {
            year = str.substring(0, index);
            year = year + monthDaytime;
            year = year + str.substring(index, str.length());
        } else {
            year = str + monthDaytime;
        }
        XSDateTime dt = XSDateTime.parseDateTime(year);
        if (dt == null) {
            return null;
        }
        return new XSGYear(dt.calendar(), dt.tz());
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        if (aat instanceof NumericType || aat instanceof XSDuration || aat instanceof XSTime || this.isGDataType(aat) || aat instanceof XSBoolean || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        XSGYear val = this.castGYear(aat);
        if (val == null) {
            throw DynamicError.cant_cast(null);
        }
        return val;
    }

    protected boolean isGDataType(AnyAtomicType aat) {
        String type = aat.string_type();
        return type.equals("xs:gMonthDay") || type.equals("xs:gDay") || type.equals("xs:gMonth") || type.equals("xs:gYearMonth");
    }

    private boolean isCastable(AnyAtomicType aat) {
        if (aat instanceof XSString || aat instanceof XSUntypedAtomic) {
            return true;
        }
        if (aat instanceof XSTime) {
            return false;
        }
        return aat instanceof XSDate || aat instanceof XSDateTime || aat instanceof XSGYear;
    }

    private XSGYear castGYear(AnyAtomicType aat) {
        if (aat instanceof XSGYear) {
            XSGYear gy = (XSGYear)aat;
            return new XSGYear(gy.calendar(), gy.tz());
        }
        if (aat instanceof XSDate) {
            XSDate date = (XSDate)aat;
            return new XSGYear(date.calendar(), date.tz());
        }
        if (aat instanceof XSDateTime) {
            XSDateTime dateTime = (XSDateTime)aat;
            return new XSGYear(dateTime.calendar(), dateTime.tz());
        }
        return XSGYear.parse_gYear(aat.getStringValue());
    }

    public int year() {
        int y = this._calendar.get(1);
        if (this._calendar.get(0) == 0) {
            y *= -1;
        }
        return y;
    }

    public boolean timezoned() {
        return this._timezoned;
    }

    @Override
    public String getStringValue() {
        String ret = "";
        ret = ret + XSDateTime.pad_int(this.year(), 4);
        if (this.timezoned()) {
            int hrs = this.tz().hours();
            int min = this.tz().minutes();
            double secs = this.tz().seconds();
            if (hrs == 0 && min == 0 && secs == 0.0) {
                ret = ret + "Z";
            } else {
                String tZoneStr = "";
                tZoneStr = this.tz().negative() ? tZoneStr + "-" : tZoneStr + "+";
                tZoneStr = tZoneStr + XSDateTime.pad_int(hrs, 2);
                tZoneStr = tZoneStr + ":";
                tZoneStr = tZoneStr + XSDateTime.pad_int(min, 2);
                ret = ret + tZoneStr;
            }
        }
        return ret;
    }

    @Override
    public String string_type() {
        return XS_G_YEAR;
    }

    @Override
    public Calendar calendar() {
        return this._calendar;
    }

    @Override
    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        XSGYear val = (XSGYear)NumericType.get_single_type(arg, XSGYear.class);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.equals(thatcal);
    }

    public XSDuration tz() {
        return this._tz;
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_GYEAR;
    }
}

