/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.CmpEq;
import info.fingo.xactus.processor.internal.function.CmpGt;
import info.fingo.xactus.processor.internal.function.CmpLt;
import info.fingo.xactus.processor.internal.function.MathDiv;
import info.fingo.xactus.processor.internal.function.MathMinus;
import info.fingo.xactus.processor.internal.function.MathPlus;
import info.fingo.xactus.processor.internal.function.MathTimes;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.CalendarType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.XSAnyURI;
import info.fingo.xactus.processor.internal.types.XSBase64Binary;
import info.fingo.xactus.processor.internal.types.XSBoolean;
import info.fingo.xactus.processor.internal.types.XSDecimal;
import info.fingo.xactus.processor.internal.types.XSDouble;
import info.fingo.xactus.processor.internal.types.XSDuration;
import info.fingo.xactus.processor.internal.types.XSHexBinary;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.math.BigDecimal;
import javax.xml.datatype.Duration;

public class XSDayTimeDuration
extends XSDuration
implements CmpEq,
CmpLt,
CmpGt,
MathPlus,
MathMinus,
MathTimes,
MathDiv,
Cloneable {
    private static final String XS_DAY_TIME_DURATION = "xs:dayTimeDuration";

    public XSDayTimeDuration(int days, int hours, int minutes, double seconds, boolean negative) {
        super(0, 0, days, hours, minutes, seconds, negative);
    }

    public XSDayTimeDuration(double secs) {
        super(0, 0, 0, 0, 0, Math.abs(secs), secs < 0.0);
    }

    public XSDayTimeDuration() {
        super(0, 0, 0, 0, 0, 0.0, false);
    }

    public XSDayTimeDuration(Duration d) {
        this(d.getDays(), d.getHours(), d.getMinutes(), 0.0, d.getSign() == -1);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new XSDayTimeDuration(this.days(), this.hours(), this.minutes(), this.seconds(), this.negative());
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        if (aat instanceof NumericType || aat instanceof CalendarType || aat instanceof XSBoolean || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        XSDuration dtd = this.castDayTimeDuration(aat);
        if (dtd == null) {
            throw DynamicError.cant_cast(null);
        }
        return dtd;
    }

    private XSDuration castDayTimeDuration(AnyAtomicType aat) {
        if (aat instanceof XSDuration) {
            XSDuration duration = (XSDuration)aat;
            return new XSDayTimeDuration(duration.days(), duration.hours(), duration.minutes(), duration.seconds(), duration.negative());
        }
        return XSDayTimeDuration.parseDTDuration(aat.getStringValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XSDuration parseDTDuration(String str) {
        boolean negative = false;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        double seconds = 0.0;
        String pstr = null;
        String tstr = null;
        if (str.startsWith("-P")) {
            negative = true;
            pstr = str.substring(2, str.length());
        } else {
            if (!str.startsWith("P")) return null;
            negative = false;
            pstr = str.substring(1, str.length());
        }
        try {
            String digit;
            int index = pstr.indexOf(68);
            boolean did_something = false;
            if (index == -1) {
                if (!pstr.startsWith("T")) return null;
                tstr = pstr.substring(1, pstr.length());
            } else {
                digit = pstr.substring(0, index);
                days = Integer.parseInt(digit);
                tstr = pstr.substring(index + 1, pstr.length());
                if (tstr.startsWith("T")) {
                    tstr = tstr.substring(1, tstr.length());
                } else {
                    if (tstr.length() > 0) {
                        return null;
                    }
                    tstr = "";
                    did_something = true;
                }
            }
            index = tstr.indexOf(72);
            if (index != -1) {
                digit = tstr.substring(0, index);
                hours = Integer.parseInt(digit);
                tstr = tstr.substring(index + 1, tstr.length());
                did_something = true;
            }
            if ((index = tstr.indexOf(77)) != -1) {
                digit = tstr.substring(0, index);
                minutes = Integer.parseInt(digit);
                tstr = tstr.substring(index + 1, tstr.length());
                did_something = true;
            }
            if ((index = tstr.indexOf(83)) != -1) {
                digit = tstr.substring(0, index);
                seconds = Double.parseDouble(digit);
                tstr = tstr.substring(index + 1, tstr.length());
                did_something = true;
            }
            if (!did_something) return null;
            if (tstr.length() == 0) return new XSDayTimeDuration(days, hours, minutes, seconds, negative);
            return null;
        }
        catch (NumberFormatException err) {
            return null;
        }
    }

    @Override
    public String type_name() {
        return "dayTimeDuration";
    }

    @Override
    public String string_type() {
        return XS_DAY_TIME_DURATION;
    }

    @Override
    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        XSDuration val = (XSDuration)NumericType.get_single_type(arg, XSDayTimeDuration.class);
        double res = this.value() + val.value();
        return new XSDayTimeDuration(res);
    }

    @Override
    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        XSDuration val = (XSDuration)NumericType.get_single_type(arg, XSDayTimeDuration.class);
        double res = this.value() - val.value();
        return new XSDayTimeDuration(res);
    }

    @Override
    public ResultSequence times(ResultSequence arg) throws DynamicError {
        XSDouble val;
        Item argValue;
        ResultSequence convertedRS = arg;
        if (arg.size() == 1 && (argValue = arg.first()) instanceof XSDecimal) {
            convertedRS = new XSDouble(argValue.getStringValue());
        }
        if ((val = (XSDouble)NumericType.get_single_type(convertedRS, XSDouble.class)).nan()) {
            throw DynamicError.nan();
        }
        double res = this.value() * val.double_value();
        return new XSDayTimeDuration(res);
    }

    @Override
    public ResultSequence div(ResultSequence arg) throws DynamicError {
        Item at;
        if (arg.size() != 1) {
            DynamicError.throw_type_error();
        }
        if ((at = arg.first()) instanceof XSDouble) {
            XSDouble dt = (XSDouble)at;
            double retval = 0.0;
            if (dt.nan()) {
                throw DynamicError.nan();
            }
            if (!dt.zero()) {
                BigDecimal ret = new BigDecimal(0);
                if (dt.infinite()) {
                    retval = this.value() / dt.double_value();
                } else {
                    ret = new BigDecimal(this.value());
                    ret = ret.divide(new BigDecimal(dt.double_value()), 18, 6);
                    retval = ret.doubleValue();
                }
            } else {
                throw DynamicError.overflowUnderflow();
            }
            return new XSDayTimeDuration(retval);
        }
        if (at instanceof XSDecimal) {
            XSDecimal dt = (XSDecimal)at;
            BigDecimal ret = new BigDecimal(0);
            if (dt.zero()) {
                throw DynamicError.overflowUnderflow();
            }
            ret = new BigDecimal(this.value());
            ret = ret.divide(dt.getValue(), 18, 6);
            return new XSDayTimeDuration(ret.intValue());
        }
        if (at instanceof XSDayTimeDuration) {
            XSDuration md = (XSDuration)at;
            BigDecimal res = null;
            res = new BigDecimal(this.value());
            BigDecimal l = new BigDecimal(md.value());
            res = res.divide(l, 18, 6);
            return ResultBuffer.wrap(new XSDecimal(res));
        }
        DynamicError.throw_type_error();
        return null;
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_DAYTIMEDURATION;
    }
}

