/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.CmpEq;
import info.fingo.xactus.processor.internal.function.CmpGt;
import info.fingo.xactus.processor.internal.function.CmpLt;
import info.fingo.xactus.processor.internal.function.MathMinus;
import info.fingo.xactus.processor.internal.function.MathPlus;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.CalendarType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.XSAnyURI;
import info.fingo.xactus.processor.internal.types.XSBase64Binary;
import info.fingo.xactus.processor.internal.types.XSBoolean;
import info.fingo.xactus.processor.internal.types.XSDate;
import info.fingo.xactus.processor.internal.types.XSDayTimeDuration;
import info.fingo.xactus.processor.internal.types.XSDuration;
import info.fingo.xactus.processor.internal.types.XSHexBinary;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.types.XSTime;
import info.fingo.xactus.processor.internal.types.XSUntypedAtomic;
import info.fingo.xactus.processor.internal.types.XSYearMonthDuration;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

public class XSDateTime
extends CalendarType
implements CmpEq,
CmpLt,
CmpGt,
MathMinus,
MathPlus,
Cloneable {
    private static final String XS_DATE_TIME = "xs:dateTime";
    private Calendar _calendar;
    private boolean _timezoned;
    private XSDuration _tz;

    public XSDateTime(Calendar cal, XSDuration tz) {
        this._calendar = cal;
        this._tz = tz;
        this._timezoned = tz != null;
    }

    public Object clone() throws CloneNotSupportedException {
        Calendar c = (Calendar)this.calendar().clone();
        XSDuration t = this.tz();
        if (t != null) {
            t = (XSDuration)t.clone();
        }
        return new XSDateTime(c, t);
    }

    public XSDateTime() {
        this(new GregorianCalendar(), null);
    }

    @Override
    public String type_name() {
        return "dateTime";
    }

    public static boolean is_digit(char x) {
        return '0' <= x && x <= '9';
    }

    public static int[] parse_date(String str) {
        int state = 0;
        int[] ret = new int[3];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = 0;
        }
        String token = "";
        block7: for (int i = 0; i < str.length(); ++i) {
            char x = str.charAt(i);
            switch (state) {
                case 0: {
                    if (XSDateTime.is_digit(x)) {
                        token = token + x;
                    } else if (x == '-') {
                        token = token + x;
                    } else {
                        return null;
                    }
                    state = 1;
                    continue block7;
                }
                case 1: {
                    if (x == '-') {
                        int uyl;
                        String uy = token;
                        if (uy.startsWith("-")) {
                            uy = uy.substring(1, uy.length());
                        }
                        if ((uyl = uy.length()) < 4) {
                            return null;
                        }
                        if (uyl == 4 ? uy.compareTo("0000") == 0 : uy.charAt(0) == '0') {
                            return null;
                        }
                        ret[0] = Integer.parseInt(token);
                        token = "";
                        state = 2;
                        continue block7;
                    }
                    if (XSDateTime.is_digit(x)) {
                        token = token + x;
                        continue block7;
                    }
                    return null;
                }
                case 2: {
                    if (x == '-') {
                        if (token.length() != 2) {
                            return null;
                        }
                        ret[1] = Integer.parseInt(token);
                        token = "";
                        state = 3;
                        continue block7;
                    }
                    if (XSDateTime.is_digit(x)) {
                        token = token + x;
                        continue block7;
                    }
                    return null;
                }
                case 3: {
                    if (XSDateTime.is_digit(x)) {
                        token = token + x;
                        continue block7;
                    }
                    return null;
                }
                default: {
                    assert (false);
                    return ret;
                }
            }
        }
        if (state != 3) {
            return null;
        }
        if (token.length() != 2) {
            return null;
        }
        ret[2] = Integer.parseInt(token);
        return ret;
    }

    public static double[] parse_time(String str) {
        int state = 0;
        double[] ret = new double[3];
        String token = "";
        block5: for (int i = 0; i < str.length(); ++i) {
            char x = str.charAt(i);
            switch (state) {
                case 0: 
                case 1: {
                    if (x == ':') {
                        if (token.length() != 2) {
                            return null;
                        }
                        ret[state] = Integer.parseInt(token);
                        ++state;
                        token = "";
                        continue block5;
                    }
                    if (XSDateTime.is_digit(x)) {
                        token = token + x;
                        continue block5;
                    }
                    return null;
                }
                case 2: {
                    if (XSDateTime.is_digit(x)) {
                        if ((token = token + x).length() <= 2) continue block5;
                        return null;
                    }
                    if (x == '.') {
                        token = token + x;
                        state = 3;
                        continue block5;
                    }
                    return null;
                }
                case 3: {
                    if (XSDateTime.is_digit(x)) {
                        token = token + x;
                        continue block5;
                    }
                    return null;
                }
                default: {
                    assert (false);
                    return null;
                }
            }
        }
        if (state != 3 && state != 2) {
            return null;
        }
        if (token.length() == 3) {
            return null;
        }
        ret[2] = Double.parseDouble(token);
        if (ret[0] == 24.0) {
            ret[0] = 0.0;
        }
        return ret;
    }

    public static int[] parse_timezone(String str) {
        int[] ret = new int[3];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = 0;
        }
        ret[0] = 1;
        if (str.equals("Z")) {
            return ret;
        }
        if (str.startsWith("+")) {
            ret[0] = 1;
        } else if (str.startsWith("-")) {
            ret[0] = -1;
        } else {
            return null;
        }
        str = str.substring(1, str.length());
        if (str.length() != 5) {
            return null;
        }
        try {
            ret[1] = Integer.parseInt(str.substring(0, 2));
            ret[2] = Integer.parseInt(str.substring(3, 5));
            if (ret[1] > 14) {
                return null;
            }
            if (ret[2] > 59) {
                return null;
            }
            return ret;
        }
        catch (NumberFormatException err) {
            return null;
        }
    }

    private static boolean set_item(Calendar cal, int item, int val) {
        int min = cal.getActualMinimum(item);
        if (val < min) {
            return false;
        }
        int max = cal.getActualMaximum(item);
        if (val > max) {
            return false;
        }
        cal.set(item, val);
        return true;
    }

    public static XSDateTime parseDateTime(String str) {
        int[] d;
        int index = str.indexOf(84);
        if (index == -1) {
            return null;
        }
        String date = str.substring(0, index);
        String time = str.substring(index + 1, str.length());
        String timezone = null;
        index = time.indexOf(43);
        if (index == -1) {
            index = time.indexOf(45);
        }
        if (index == -1) {
            index = time.indexOf(90);
        }
        if (index != -1) {
            timezone = time.substring(index, time.length());
            time = time.substring(0, index);
        }
        if ((d = XSDateTime.parse_date(date)) == null) {
            return null;
        }
        if (d[0] == 0) {
            throw new IllegalArgumentException("Year cannot be 0 according to the ISO 8601 standard.");
        }
        double[] t = XSDateTime.parse_time(time);
        if (t == null) {
            return null;
        }
        int ms = (int)(t[2] * 1000.0 - (double)((int)t[2] * 1000));
        String instantString = String.format("%s%04d-%02d-%02dT%02d:%02d:%02d.%03dZ", d[0] < -1 ? "-" : "", d[0] < 0 ? -1 * d[0] - 1 : d[0], d[1], d[2], (int)t[0], (int)t[1], (int)t[2], ms);
        GregorianCalendar cal = GregorianCalendar.from(Instant.parse(instantString).atOffset(ZoneOffset.UTC).toZonedDateTime());
        int[] tz = null;
        XSDayTimeDuration tzd = null;
        if (timezone != null) {
            tz = XSDateTime.parse_timezone(timezone);
            if (tz == null) {
                return null;
            }
            tzd = new XSDayTimeDuration(0, tz[1], tz[2], 0.0, tz[0] < 0);
        }
        return new XSDateTime(cal, tzd);
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        if (aat instanceof NumericType || aat instanceof XSDuration || aat instanceof XSTime || this.isGDataType(aat) || aat instanceof XSBoolean || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        CalendarType dt = this.castDateTime(aat);
        if (dt == null) {
            throw DynamicError.cant_cast(null);
        }
        return dt;
    }

    private boolean isCastable(AnyAtomicType aat) {
        if (aat instanceof XSString || aat instanceof XSUntypedAtomic) {
            return true;
        }
        if (aat instanceof XSTime) {
            return false;
        }
        return aat instanceof XSDate || aat instanceof XSDateTime;
    }

    private CalendarType castDateTime(AnyAtomicType aat) {
        if (aat instanceof XSDate) {
            XSDate date = (XSDate)aat;
            return new XSDateTime(date.calendar(), date.tz());
        }
        if (aat instanceof XSDateTime) {
            XSDateTime dateTime = (XSDateTime)aat;
            return new XSDateTime(dateTime.calendar(), dateTime.tz());
        }
        return XSDateTime.parseDateTime(aat.getStringValue());
    }

    public int year() {
        int y = this._calendar.get(1);
        if (this._calendar.get(0) == 0) {
            y *= -1;
        }
        return y;
    }

    public int month() {
        return this._calendar.get(2) + 1;
    }

    public int day() {
        return this._calendar.get(5);
    }

    public int hour() {
        return this._calendar.get(11);
    }

    public int minute() {
        return this._calendar.get(12);
    }

    public double second() {
        double s = this._calendar.get(13);
        double ms = this._calendar.get(14);
        return s += (ms /= 1000.0);
    }

    public boolean timezoned() {
        return this._timezoned;
    }

    public static String pad_int(int num, int len) {
        String ret = "";
        String snum = "" + num;
        int pad = len - snum.length();
        if (num < 0) {
            ret = ret + "-";
            snum = snum.substring(1, snum.length());
            ++pad;
        }
        StringBuffer buf = new StringBuffer(ret);
        for (int i = 0; i < pad; ++i) {
            buf.append("0");
        }
        buf.append(snum);
        ret = buf.toString();
        return ret;
    }

    @Override
    public String getStringValue() {
        String ret = "";
        Calendar adjustFortimezone = this.calendar();
        if (adjustFortimezone.get(0) == 0) {
            ret = ret + "-";
        }
        ret = ret + XSDateTime.pad_int(adjustFortimezone.get(1), 4);
        ret = ret + "-";
        ret = ret + XSDateTime.pad_int(this.month(), 2);
        ret = ret + "-";
        ret = ret + XSDateTime.pad_int(adjustFortimezone.get(5), 2);
        ret = ret + "T";
        ret = ret + XSDateTime.pad_int(adjustFortimezone.get(11), 2);
        ret = ret + ":";
        ret = ret + XSDateTime.pad_int(adjustFortimezone.get(12), 2);
        ret = ret + ":";
        int isecond = (int)this.second();
        double sec = this.second();
        ret = sec - (double)isecond == 0.0 ? ret + XSDateTime.pad_int(isecond, 2) : (sec < 10.0 ? ret + "0" + sec : ret + sec);
        if (this.timezoned()) {
            int hrs = this._tz.hours();
            int min = this._tz.minutes();
            double secs = this._tz.seconds();
            if (hrs == 0 && min == 0 && secs == 0.0) {
                ret = ret + "Z";
            } else {
                String tZoneStr = "";
                tZoneStr = this._tz.negative() ? tZoneStr + "-" : tZoneStr + "+";
                tZoneStr = tZoneStr + XSDateTime.pad_int(hrs, 2);
                tZoneStr = tZoneStr + ":";
                tZoneStr = tZoneStr + XSDateTime.pad_int(min, 2);
                ret = ret + tZoneStr;
            }
        }
        return ret;
    }

    @Override
    public String string_type() {
        return XS_DATE_TIME;
    }

    @Override
    public Calendar calendar() {
        return this._calendar;
    }

    @Override
    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        XSDateTime val = (XSDateTime)NumericType.get_single_type(arg, XSDateTime.class);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.equals(thatcal);
    }

    @Override
    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        XSDateTime val = (XSDateTime)NumericType.get_single_type(arg, XSDateTime.class);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.before(thatcal);
    }

    @Override
    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        XSDateTime val = (XSDateTime)NumericType.get_single_type(arg, XSDateTime.class);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.after(thatcal);
    }

    public XSDuration tz() {
        return this._tz;
    }

    public double value() {
        return (double)this.calendar().getTimeInMillis() / 1000.0;
    }

    @Override
    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        Item at;
        if (arg.size() != 1) {
            DynamicError.throw_type_error();
        }
        if (!((at = arg.first()) instanceof XSDateTime || at instanceof XSYearMonthDuration || at instanceof XSDayTimeDuration)) {
            DynamicError.throw_type_error();
        }
        if (at instanceof XSDateTime) {
            return this.minusXSDateTime(arg);
        }
        if (at instanceof XSYearMonthDuration) {
            return this.minusXSYearMonthDuration(at);
        }
        if (at instanceof XSDayTimeDuration) {
            return this.minusXSDayTimeDuration(at);
        }
        return null;
    }

    private ResultSequence minusXSDateTime(ResultSequence arg) throws DynamicError {
        XSDateTime val = (XSDateTime)NumericType.get_single_type(arg, XSDateTime.class);
        Calendar thisCal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatCal = this.normalizeCalendar(val.calendar(), val.tz());
        long duration = thisCal.getTimeInMillis() - thatCal.getTimeInMillis();
        Duration dtduration = _datatypeFactory.newDuration(duration);
        return XSDayTimeDuration.parseDTDuration(dtduration.toString());
    }

    private ResultSequence minusXSDayTimeDuration(Item at) {
        XSDuration val = (XSDuration)at;
        try {
            XSDateTime res = (XSDateTime)this.clone();
            XMLGregorianCalendar xmlCal = _datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)this.calendar());
            Duration dtduration = _datatypeFactory.newDuration(val.getStringValue());
            xmlCal.add(dtduration.negate());
            res = new XSDateTime(xmlCal.toGregorianCalendar(), res.tz());
            return res;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private ResultSequence minusXSYearMonthDuration(Item at) {
        XSYearMonthDuration val = (XSYearMonthDuration)at;
        try {
            XSDateTime res = (XSDateTime)this.clone();
            res.calendar().add(2, val.monthValue() * -1);
            return res;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        if (arg.size() != 1) {
            DynamicError.throw_type_error();
        }
        Item at = arg.first();
        try {
            if (at instanceof XSYearMonthDuration) {
                XSYearMonthDuration val = (XSYearMonthDuration)at;
                XSDateTime res = (XSDateTime)this.clone();
                res.calendar().add(2, val.monthValue());
                return res;
            }
            if (at instanceof XSDayTimeDuration) {
                XSDuration val = (XSDuration)at;
                XSDateTime res = (XSDateTime)this.clone();
                XMLGregorianCalendar xmlCal = _datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)this.calendar());
                Duration dtduration = _datatypeFactory.newDuration(val.getStringValue());
                xmlCal.add(dtduration);
                res = new XSDateTime(xmlCal.toGregorianCalendar(), res.tz());
                return res;
            }
            DynamicError.throw_type_error();
            return null;
        }
        catch (CloneNotSupportedException err) {
            assert (false);
            return null;
        }
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_DATETIME;
    }
}

