/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.api.typesystem.TypeModel;
import info.fingo.xactus.processor.internal.types.NodeType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSBoolean;
import info.fingo.xactus.processor.internal.types.XSUntypedAtomic;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import org.apache.xerces.dom.PSVIElementNSImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public class ElementType
extends NodeType {
    private static final String ELEMENT = "element";
    private static final String SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String NIL_ATTRIBUTE = "nil";
    private static final String TRUE_VALUE = "true";

    public ElementType() {
        this(null, null);
    }

    public ElementType(Element v, TypeModel tm) {
        super(v, tm);
    }

    public Element value() {
        return (Element)this.node_value();
    }

    @Override
    public String string_type() {
        return ELEMENT;
    }

    @Override
    public String getStringValue() {
        return ElementType.textnode_strings(this.value());
    }

    @Override
    public ResultSequence typed_value() {
        TypeDefinition typeDef = this.getType();
        Element value = this.value();
        if (!this.isNilled(value)) {
            if (typeDef != null) {
                return this.getXDMTypedValue(typeDef, typeDef.getSimpleTypes(value));
            }
            return new XSUntypedAtomic(this.getStringValue());
        }
        return ResultBuffer.EMPTY;
    }

    private boolean isNilled(Element _value2) {
        return TRUE_VALUE.equals(_value2.getAttributeNS(SCHEMA_INSTANCE, NIL_ATTRIBUTE));
    }

    public static String textnode_strings(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        if (node.getNodeType() == 3) {
            stringBuilder.append(((Text)node).getData());
        }
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            stringBuilder.append(ElementType.textnode_strings(childNodes.item(i)));
        }
        String nodeText = stringBuilder.toString();
        return node.getNodeType() == 1 ? nodeText.trim() : nodeText;
    }

    @Override
    public QName node_name() {
        Element value = this.value();
        QName name = new QName(value.getPrefix(), value.getLocalName(), value.getNamespaceURI());
        return name;
    }

    @Override
    public ResultSequence nilled() {
        Element value = this.value();
        if (value instanceof PSVIElementNSImpl) {
            PSVIElementNSImpl psviElement = (PSVIElementNSImpl)value;
            return XSBoolean.valueOf(psviElement.getNil());
        }
        return XSBoolean.valueOf(this.isNilled(value));
    }

    @Override
    public boolean isID() {
        return this.isElementType("ID");
    }

    @Override
    public boolean isIDREF() {
        return this.isElementType("IDREF");
    }

    protected boolean isElementType(String typeName) {
        TypeInfo typeInfo = this.value().getSchemaTypeInfo();
        return this.isType(typeInfo, typeName);
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_UNTYPED;
    }
}

