/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.TypeError;
import info.fingo.xactus.processor.internal.function.CmpEq;
import info.fingo.xactus.processor.internal.function.FnData;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSBoolean;
import info.fingo.xactus.processor.internal.types.XSDouble;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.types.XSUntypedAtomic;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class FsEq
extends Function {
    public FsEq() {
        super(new QName("eq"), 2);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        assert (args.size() >= this.min_arity() && args.size() <= this.max_arity());
        return FsEq.fs_eq_value(args, ec.getDynamicContext());
    }

    private static Collection value_convert_args(Collection args) throws DynamicError {
        ArrayList<Item> result = new ArrayList<Item>(args.size());
        for (ResultSequence rs : args) {
            if ((rs = FnData.atomize(rs)).empty()) {
                return new ArrayList();
            }
            if (rs.size() > 1) {
                throw new DynamicError(TypeError.invalid_type(null));
            }
            Item arg = rs.first();
            if (arg instanceof XSUntypedAtomic) {
                arg = new XSString(arg.getStringValue());
            }
            result.add(arg);
        }
        return result;
    }

    public static ResultSequence fs_eq_value(Collection args, DynamicContext context) throws DynamicError {
        return FsEq.do_cmp_value_op(args, CmpEq.class, "eq", context);
    }

    public static boolean fs_eq_fast(AnyType one, AnyType two, DynamicContext context) throws DynamicError {
        one = FnData.atomize(one);
        two = FnData.atomize(two);
        if (one instanceof XSUntypedAtomic) {
            one = new XSString(one.getStringValue());
        }
        if (two instanceof XSUntypedAtomic) {
            two = new XSString(two.getStringValue());
        }
        if (!(one instanceof CmpEq)) {
            DynamicError.throw_type_error();
        }
        CmpEq cmpone = (CmpEq)((Object)one);
        return cmpone.eq(two, context);
    }

    private static boolean do_general_pair(AnyType a, AnyType b, Method comparator, DynamicContext ec) throws DynamicError {
        if (a instanceof XSUntypedAtomic && b instanceof NumericType || b instanceof XSUntypedAtomic && a instanceof NumericType) {
            if (a instanceof XSUntypedAtomic) {
                a = new XSDouble(a.getStringValue());
            } else {
                b = new XSDouble(b.getStringValue());
            }
        } else if (a instanceof XSUntypedAtomic && (b instanceof XSString || b instanceof XSUntypedAtomic) || b instanceof XSUntypedAtomic && (a instanceof XSString || a instanceof XSUntypedAtomic)) {
            if (a instanceof XSUntypedAtomic) {
                a = new XSString(a.getStringValue());
            }
            if (b instanceof XSUntypedAtomic) {
                b = new XSString(b.getStringValue());
            }
        } else if (a instanceof XSUntypedAtomic || b instanceof XSUntypedAtomic) {
            // empty if block
        }
        AnyType one = a;
        AnyType two = b;
        ArrayList<AnyType> args = new ArrayList<AnyType>();
        args.add(one);
        args.add(two);
        Object[] margs = new Object[]{args, ec};
        ResultSequence result = null;
        try {
            result = (ResultSequence)comparator.invoke(null, margs);
        }
        catch (IllegalAccessException err) {
            assert (false);
        }
        catch (InvocationTargetException err) {
            Throwable ex = err.getTargetException();
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        return ((XSBoolean)result.first()).value();
    }

    public static ResultSequence fs_eq_general(Collection args, DynamicContext dc) {
        return FsEq.do_cmp_general_op(args, FsEq.class, "fs_eq_value", dc);
    }

    public static ResultSequence do_cmp_general_op(Collection args, Class type, String mname, DynamicContext dc) throws DynamicError {
        Method comparator = null;
        try {
            Class[] margsdef = new Class[]{Collection.class, DynamicContext.class};
            comparator = type.getMethod(mname, margsdef);
        }
        catch (NoSuchMethodException err) {
            throw new RuntimeException("Can't find method : " + mname, err);
        }
        if (args.size() != 2) {
            DynamicError.throw_type_error();
        }
        Iterator argiter = args.iterator();
        ResultSequence one = (ResultSequence)argiter.next();
        ResultSequence two = (ResultSequence)argiter.next();
        if (one.empty() || two.empty()) {
            return XSBoolean.FALSE;
        }
        one = FnData.atomize(one);
        two = FnData.atomize(two);
        for (AnyType a : one) {
            for (AnyType b : two) {
                if (!FsEq.do_general_pair(a, b, comparator, dc)) continue;
                return XSBoolean.TRUE;
            }
        }
        return XSBoolean.FALSE;
    }

    public static ResultSequence do_cmp_value_op(Collection args, Class type, String mname, DynamicContext context) throws DynamicError {
        Collection cargs;
        if (args.size() != 2) {
            DynamicError.throw_type_error();
        }
        if ((cargs = FsEq.value_convert_args(args)).size() == 0) {
            return ResultBuffer.EMPTY;
        }
        Iterator argi = cargs.iterator();
        Item arg = ((ResultSequence)argi.next()).first();
        ResultSequence arg2 = (ResultSequence)argi.next();
        if (arg2.size() != 1) {
            DynamicError.throw_type_error();
        }
        if (!type.isInstance(arg)) {
            DynamicError.throw_type_error();
        }
        try {
            Class[] margsdef = new Class[]{AnyType.class, DynamicContext.class};
            Method method = null;
            method = type.getMethod(mname, margsdef);
            Object[] margs = new Object[]{arg2.first(), context};
            Boolean cmpres = (Boolean)method.invoke((Object)arg, margs);
            return XSBoolean.valueOf(cmpres);
        }
        catch (NoSuchMethodException err) {
            assert (false);
            throw new RuntimeException("cannot compare using method " + mname, err);
        }
        catch (IllegalAccessException err) {
            assert (false);
            throw new RuntimeException("cannot compare using method " + mname, err);
        }
        catch (InvocationTargetException err) {
            Throwable ex = err.getTargetException();
            if (ex instanceof DynamicError) {
                throw (DynamicError)ex;
            }
            throw new RuntimeException("cannot compare using method " + mname, ex);
        }
    }
}

