/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.CtrType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSDouble;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.types.XSUntypedAtomic;
import java.util.Collection;
import java.util.Iterator;

public class FsConvertOperand
extends Function {
    public FsConvertOperand() {
        super(new QName("convert-operand"), 2);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FsConvertOperand.convert_operand(args);
    }

    public static ResultSequence convert_operand(Collection args) throws DynamicError {
        Item at;
        assert (args.size() == 2);
        Iterator iter = args.iterator();
        ResultSequence actual = (ResultSequence)iter.next();
        ResultSequence expected = (ResultSequence)iter.next();
        if (expected.size() != 1) {
            DynamicError.throw_type_error();
        }
        if (!((at = expected.first()) instanceof AnyAtomicType)) {
            DynamicError.throw_type_error();
        }
        AnyAtomicType exp_aat = (AnyAtomicType)at;
        ResultBuffer result = new ResultBuffer();
        if (actual.empty()) {
            return result.getSequence();
        }
        for (Item i : actual) {
            AnyType item = (AnyType)i;
            if (item instanceof XSUntypedAtomic) {
                if (exp_aat instanceof XSUntypedAtomic) {
                    result.add(new XSString(item.getStringValue()));
                    continue;
                }
                if (exp_aat instanceof NumericType) {
                    result.add(new XSDouble(item.getStringValue()));
                    continue;
                }
                assert (exp_aat instanceof CtrType);
                CtrType cons = (CtrType)exp_aat;
                result.concat(cons.constructor(new XSString(item.getStringValue())));
                continue;
            }
            result.add(item);
        }
        return result.getSequence();
    }
}

