/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSDouble;
import java.util.Collection;
import java.util.Iterator;

public class FnSubsequence
extends Function {
    public FnSubsequence() {
        super(new QName("subsequence"), 2, 3);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnSubsequence.subsequence(args);
    }

    public static ResultSequence subsequence(Collection args) throws DynamicError {
        Item at;
        ResultBuffer rs = new ResultBuffer();
        Iterator citer = args.iterator();
        ResultSequence seq = (ResultSequence)citer.next();
        if (seq.empty()) {
            return ResultBuffer.EMPTY;
        }
        ResultSequence startLoc = (ResultSequence)citer.next();
        ResultSequence length = null;
        if (citer.hasNext()) {
            length = (ResultSequence)citer.next();
        }
        if (!((at = startLoc.first()) instanceof NumericType)) {
            DynamicError.throw_type_error();
        }
        at = new XSDouble(at.getStringValue());
        int start = (int)((XSDouble)at).double_value();
        int effectiveNoItems = 0;
        if (length != null) {
            int len;
            if (length.size() != 1) {
                DynamicError.throw_type_error();
            }
            if (!((at = length.first()) instanceof NumericType)) {
                DynamicError.throw_type_error();
            }
            if ((len = (int)((XSDouble)(at = new XSDouble(at.getStringValue()))).double_value()) < 0) {
                DynamicError.throw_type_error();
            }
            if (start <= 0) {
                effectiveNoItems = start + len - 1;
                start = 1;
            } else {
                effectiveNoItems = len;
            }
        } else if (start <= 0) {
            start = 1;
            effectiveNoItems = seq.size();
        } else {
            effectiveNoItems = seq.size() - start + 1;
        }
        int pos = 1;
        int addedItems = 0;
        if (effectiveNoItems > 0) {
            for (Item next : seq) {
                at = (AnyType)next;
                if (start <= pos && addedItems < effectiveNoItems) {
                    rs.add(at);
                    ++addedItems;
                }
                ++pos;
            }
        }
        return rs.getSequence();
    }
}

