/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.CmpGt;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSDouble;
import info.fingo.xactus.processor.internal.types.XSFloat;
import info.fingo.xactus.processor.internal.utils.ComparableTypePromoter;
import java.util.Collection;

public class FnMax
extends Function {
    public FnMax() {
        super(new QName("max"), 1);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) {
        return FnMax.max(args, ec.getDynamicContext());
    }

    public static ResultSequence max(Collection args, DynamicContext dynamicContext) throws DynamicError {
        ResultSequence arg = FnMax.get_arg(args, CmpGt.class);
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        CmpGt max = null;
        ComparableTypePromoter tp = new ComparableTypePromoter();
        tp.considerSequence(arg);
        for (Item next : arg) {
            AnyAtomicType conv = tp.promote((AnyType)next);
            if (conv == null) continue;
            if (conv instanceof XSDouble && ((XSDouble)conv).nan() || conv instanceof XSFloat && ((XSFloat)conv).nan()) {
                return tp.promote(new XSFloat(Float.NaN));
            }
            if (max != null && !((CmpGt)((Object)conv)).gt((AnyType)((Object)max), dynamicContext)) continue;
            max = (CmpGt)((Object)conv);
        }
        return (AnyType)((Object)max);
    }

    public static ResultSequence get_arg(Collection args, Class op) throws DynamicError {
        assert (args.size() == 1);
        ResultSequence arg = (ResultSequence)args.iterator().next();
        return arg;
    }
}

