/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.SeqType;
import info.fingo.xactus.processor.internal.TypeError;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.ElementType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FnInScopePrefixes
extends Function {
    private static Collection _expected_args = null;

    public FnInScopePrefixes() {
        super(new QName("in-scope-prefixes"), 1);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnInScopePrefixes.inScopePrefixes(args, ec.getDynamicContext());
    }

    public static ResultSequence inScopePrefixes(Collection args, DynamicContext dc) throws DynamicError {
        Collection cargs = args;
        ResultSequence arg1 = (ResultSequence)cargs.iterator().next();
        if (arg1.empty()) {
            return ResultBuffer.EMPTY;
        }
        ResultBuffer rs = new ResultBuffer();
        Item anytype = arg1.item(0);
        if (!(anytype instanceof ElementType)) {
            throw new DynamicError(TypeError.invalid_type(null));
        }
        ElementType element = (ElementType)anytype;
        List prefixList = FnInScopePrefixes.lookupPrefixes(element);
        FnInScopePrefixes.createPrefixResultSet(rs, prefixList);
        return rs.getSequence();
    }

    private static void createPrefixResultSet(ResultBuffer rs, List prefixList) {
        for (int i = 0; i < prefixList.size(); ++i) {
            String prefix = (String)prefixList.get(i);
            rs.add(new XSString(prefix));
        }
    }

    private static List lookupPrefixes(ElementType element) {
        Element domElm = (Element)element.node_value();
        ArrayList<String> prefixList = new ArrayList<String>();
        for (Node node = domElm; node != null && node.getNodeType() != 9; node = node.getParentNode()) {
            NamedNodeMap attrs = node.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                String prefix = null;
                if (attr.getNamespaceURI() == null || !attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/") || (prefix = attr.getNodeName().equals("xmlns") ? "" : attr.getLocalName()) == null || prefixList.contains(prefix)) continue;
                prefixList.add(prefix);
            }
        }
        return prefixList;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(new ElementType(), 2);
            _expected_args.add(arg);
        }
        return _expected_args;
    }
}

