/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.SeqType;
import info.fingo.xactus.processor.internal.TypeError;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.AttrType;
import info.fingo.xactus.processor.internal.types.ElementType;
import info.fingo.xactus.processor.internal.types.NodeType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSID;
import info.fingo.xactus.processor.internal.types.XSString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FnIDREF
extends Function {
    private static Collection _expected_args = null;

    public FnIDREF() {
        super(new QName("idref"), 1, 2);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnIDREF.idref(args, ec);
    }

    public static ResultSequence idref(Collection args, EvaluationContext ec) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnIDREF.expected_args());
        ResultBuffer rs = new ResultBuffer();
        Iterator argIt = cargs.iterator();
        ResultSequence idrefRS = (ResultSequence)argIt.next();
        String[] idst = idrefRS.first().getStringValue().split(" ");
        ArrayList ids = FnIDREF.createIDs(idst);
        ResultSequence nodeArg = null;
        NodeType nodeType = null;
        if (argIt.hasNext()) {
            nodeArg = (ResultSequence)argIt.next();
            nodeType = (NodeType)nodeArg.first();
        } else {
            if (ec.getContextItem() == null) {
                throw DynamicError.contextUndefined();
            }
            if (!(ec.getContextItem() instanceof NodeType)) {
                throw new DynamicError(TypeError.invalid_type(null));
            }
            nodeType = (NodeType)ec.getContextItem();
            if (nodeType.node_value().getOwnerDocument() == null) {
                throw DynamicError.contextUndefined();
            }
        }
        Node node = nodeType.node_value();
        if (node.getOwnerDocument() == null) {
            throw DynamicError.contextUndefined();
        }
        if (FnIDREF.hasID(ids, node)) {
            ElementType element = new ElementType((Element)node, ec.getStaticContext().getTypeModel());
            rs.add(element);
        }
        rs = FnIDREF.processAttributes(node, ids, rs, ec);
        rs = FnIDREF.processChildNodes(node, ids, rs, ec);
        return rs.getSequence();
    }

    private static ArrayList createIDs(String[] idtokens) {
        ArrayList<XSID> xsid = new ArrayList<XSID>();
        for (int i = 0; i < idtokens.length; ++i) {
            XSID id = new XSID(idtokens[i]);
            xsid.add(id);
        }
        return xsid;
    }

    private static ResultBuffer processChildNodes(Node node, List ids, ResultBuffer rs, EvaluationContext ec) {
        if (!node.hasChildNodes()) {
            return rs;
        }
        NodeList nodeList = node.getChildNodes();
        for (int nodecnt = 0; nodecnt < nodeList.getLength(); ++nodecnt) {
            Node childNode = nodeList.item(nodecnt);
            if (childNode.getNodeType() != 1 || FnIDREF.isDuplicate(childNode, rs)) continue;
            ElementType element = new ElementType((Element)childNode, ec.getStaticContext().getTypeModel());
            if (element.isIDREF() && FnIDREF.hasID(ids, childNode)) {
                rs.add(element);
            }
            rs = FnIDREF.processAttributes(childNode, ids, rs, ec);
            rs = FnIDREF.processChildNodes(childNode, ids, rs, ec);
        }
        return rs;
    }

    private static ResultBuffer processAttributes(Node node, List idrefs, ResultBuffer rs, EvaluationContext ec) {
        if (!node.hasAttributes()) {
            return rs;
        }
        NamedNodeMap attributeList = node.getAttributes();
        for (int atsub = 0; atsub < attributeList.getLength(); ++atsub) {
            Attr atNode = (Attr)attributeList.item(atsub);
            AttrType atType = new AttrType(atNode, ec.getStaticContext().getTypeModel());
            if (!((NodeType)atType).isID() || !FnIDREF.hasID(idrefs, atNode) || FnIDREF.isDuplicate(node, rs)) continue;
            ElementType element = new ElementType((Element)node, ec.getStaticContext().getTypeModel());
            rs.add(element);
        }
        return rs;
    }

    private static boolean hasID(List ids, Node node) {
        for (int i = 0; i < ids.size(); ++i) {
            XSID idref = (XSID)ids.get(i);
            if (!idref.getStringValue().equals(node.getNodeValue())) continue;
            return true;
        }
        return false;
    }

    private static boolean isDuplicate(Node node, ResultBuffer rs) {
        ListIterator<Item> it = rs.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(node)) continue;
            return true;
        }
        return false;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(new XSString(), 1);
            _expected_args.add(arg);
            _expected_args.add(new SeqType(0));
        }
        return _expected_args;
    }
}

