/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.SeqType;
import info.fingo.xactus.processor.internal.TypeError;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.AttrType;
import info.fingo.xactus.processor.internal.types.ElementType;
import info.fingo.xactus.processor.internal.types.NodeType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSIDREF;
import info.fingo.xactus.processor.internal.types.XSString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FnID
extends Function {
    private static Collection _expected_args = null;

    public FnID() {
        super(new QName("id"), 1, 2);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnID.id(args, ec);
    }

    public static ResultSequence id(Collection args, EvaluationContext context) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnID.expected_args());
        ResultBuffer rs = new ResultBuffer();
        Iterator argIt = cargs.iterator();
        ResultSequence idrefRS = (ResultSequence)argIt.next();
        String[] idrefst = idrefRS.first().getStringValue().split(" ");
        ArrayList idrefs = FnID.createIDRefs(idrefst);
        ResultSequence nodeArg = null;
        NodeType nodeType = null;
        if (argIt.hasNext()) {
            nodeArg = (ResultSequence)argIt.next();
            nodeType = (NodeType)nodeArg.first();
        } else {
            if (context.getContextItem() == null) {
                throw DynamicError.contextUndefined();
            }
            if (!(context.getContextItem() instanceof NodeType)) {
                throw new DynamicError(TypeError.invalid_type(null));
            }
            nodeType = (NodeType)context.getContextItem();
            if (nodeType.node_value().getOwnerDocument() == null) {
                throw DynamicError.contextUndefined();
            }
        }
        Node node = nodeType.node_value();
        if (node.getOwnerDocument() == null) {
            throw DynamicError.contextUndefined();
        }
        if (FnID.hasIDREF(idrefs, node)) {
            ElementType element = new ElementType((Element)node, context.getStaticContext().getTypeModel());
            rs.add(element);
        }
        FnID.processAttributes(node, idrefs, rs, context);
        FnID.processChildNodes(node, idrefs, rs, context);
        return rs.getSequence();
    }

    private static ArrayList createIDRefs(String[] idReftokens) {
        ArrayList<XSIDREF> xsidRef = new ArrayList<XSIDREF>();
        for (int i = 0; i < idReftokens.length; ++i) {
            XSIDREF idref = new XSIDREF(idReftokens[i]);
            xsidRef.add(idref);
        }
        return xsidRef;
    }

    private static void processChildNodes(Node node, List idrefs, ResultBuffer rs, EvaluationContext context) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        for (int nodecnt = 0; nodecnt < nodeList.getLength(); ++nodecnt) {
            Node childNode = nodeList.item(nodecnt);
            if (childNode.getNodeType() != 1 || FnID.isDuplicate(childNode, rs)) continue;
            ElementType element = new ElementType((Element)childNode, context.getStaticContext().getTypeModel());
            if (element.isID() && FnID.hasIDREF(idrefs, childNode)) {
                rs.add(element);
            }
            FnID.processAttributes(childNode, idrefs, rs, context);
            FnID.processChildNodes(childNode, idrefs, rs, context);
        }
    }

    private static void processAttributes(Node node, List idrefs, ResultBuffer rs, EvaluationContext context) {
        if (!node.hasAttributes()) {
            return;
        }
        NamedNodeMap attributeList = node.getAttributes();
        for (int atsub = 0; atsub < attributeList.getLength(); ++atsub) {
            Attr atNode = (Attr)attributeList.item(atsub);
            AttrType atType = new AttrType(atNode, context.getStaticContext().getTypeModel());
            if (!((NodeType)atType).isID() || !FnID.hasIDREF(idrefs, atNode) || FnID.isDuplicate(node, rs)) continue;
            ElementType element = new ElementType((Element)node, context.getStaticContext().getTypeModel());
            rs.add(element);
        }
    }

    private static boolean hasIDREF(List idrefs, Node node) {
        for (int i = 0; i < idrefs.size(); ++i) {
            XSIDREF idref = (XSIDREF)idrefs.get(i);
            if (!idref.getStringValue().equals(node.getNodeValue())) continue;
            return true;
        }
        return false;
    }

    private static boolean isDuplicate(Node node, ResultBuffer rs) {
        ListIterator<Item> it = rs.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(node)) continue;
            return true;
        }
        return false;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(new XSString(), 1);
            _expected_args.add(arg);
            _expected_args.add(new SeqType(0));
        }
        return _expected_args;
    }
}

