/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.StaticContext;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.SeqType;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSDate;
import info.fingo.xactus.processor.internal.types.XSDateTime;
import info.fingo.xactus.processor.internal.types.XSDuration;
import info.fingo.xactus.processor.internal.types.XSTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;

public class FnDateTime
extends Function {
    private static Collection _expected_args = null;

    public FnDateTime() {
        super(new QName("dateTime"), 2);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnDateTime.dateTime(args, ec.getStaticContext());
    }

    public static ResultSequence dateTime(Collection args, StaticContext sc) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnDateTime.expected_args());
        Iterator argiter = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)argiter.next();
        ResultSequence arg2 = (ResultSequence)argiter.next();
        if (arg1.empty() || arg2.empty()) {
            return ResultBuffer.EMPTY;
        }
        XSDate param1 = (XSDate)arg1.first();
        XSTime param2 = (XSTime)arg2.first();
        String instantString = String.format("%s%04d-%02d-%02dT%02d:%02d:%02d", param1.year() < 0 ? "-" : "", Math.abs(param1.year()), param1.month(), param1.day(), param2.hour(), param2.minute(), new Double(Math.floor(param2.second())).intValue());
        XSDateTime xsDateTime = XSDateTime.parseDateTime(instantString);
        Calendar cal = xsDateTime.calendar();
        XSDuration dateTimeZone = param1.tz();
        XSDuration timeTimeZone = param2.tz();
        if (dateTimeZone != null && timeTimeZone != null && !dateTimeZone.getStringValue().equals(timeTimeZone.getStringValue())) {
            throw DynamicError.inconsistentTimeZone();
        }
        if (dateTimeZone == null && timeTimeZone != null) {
            return new XSDateTime(cal, timeTimeZone);
        }
        if (dateTimeZone != null && timeTimeZone == null) {
            return new XSDateTime(cal, dateTimeZone);
        }
        if (dateTimeZone != null && timeTimeZone != null && dateTimeZone.getStringValue().equals(timeTimeZone.getStringValue())) {
            return new XSDateTime(cal, dateTimeZone);
        }
        return new XSDateTime(cal, null);
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(new XSDate(), 3));
            _expected_args.add(new SeqType(new XSTime(), 3));
        }
        return _expected_args;
    }
}

