/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.NodeType;
import info.fingo.xactus.processor.internal.types.QName;
import java.util.Collection;

public class FnData
extends Function {
    public FnData() {
        super(new QName("data"), 1);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) {
        assert (args.size() >= this.min_arity() && args.size() <= this.max_arity());
        ResultSequence argument = (ResultSequence)args.iterator().next();
        return FnData.atomize(argument);
    }

    public static ResultSequence atomize(ResultSequence arg) {
        ResultBuffer rs = new ResultBuffer();
        for (Item next : arg) {
            AnyType at = (AnyType)next;
            if (at instanceof AnyAtomicType) {
                rs.add(at);
                continue;
            }
            if (at instanceof NodeType) {
                NodeType nt = (NodeType)at;
                rs.concat(nt.typed_value());
                continue;
            }
            throw new RuntimeException("XPath implementation error: " + at);
        }
        return rs.getSequence();
    }

    public static AnyAtomicType atomize(Item arg) {
        if (arg instanceof AnyAtomicType) {
            return (AnyAtomicType)arg;
        }
        if (arg instanceof NodeType) {
            ResultSequence nodeValues = ((NodeType)arg).typed_value();
            if (nodeValues.empty()) {
                return null;
            }
            return (AnyAtomicType)nodeValues.first();
        }
        throw new RuntimeException("XPath implemenatation error: " + arg);
    }
}

