/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import com.ibm.icu.text.UTF16;
import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.SeqType;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSInteger;
import info.fingo.xactus.processor.internal.types.XSString;
import java.util.ArrayList;
import java.util.Collection;

public class FnCodepointsToString
extends Function {
    private static Collection _expected_args = null;
    public static final int MIN_LEGAL_CODEPOINT = 1;
    public static final int MAX_LEGAL_CODEPOINT = 0x10FFFF;

    public FnCodepointsToString() {
        super(new QName("codepoints-to-string"), 1);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnCodepointsToString.codepoints_to_string(args);
    }

    public static ResultSequence codepoints_to_string(Collection args) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnCodepointsToString.expected_args());
        ResultSequence arg1 = (ResultSequence)cargs.iterator().next();
        if (arg1.empty()) {
            return new XSString("");
        }
        int[] codePointArray = new int[arg1.size()];
        int codePointIndex = 0;
        for (Item i : arg1) {
            XSInteger code = (XSInteger)i;
            int codepoint = code.int_value().intValue();
            if (codepoint < 1 || codepoint > 0x10FFFF) {
                throw DynamicError.unsupported_codepoint("U+" + Integer.toString(codepoint, 16).toUpperCase());
            }
            codePointArray[codePointIndex] = codepoint;
            ++codePointIndex;
        }
        try {
            String str = UTF16.newString(codePointArray, 0, codePointArray.length);
            return new XSString(str);
        }
        catch (IllegalArgumentException iae) {
            throw DynamicError.unsupported_codepoint(iae.getMessage());
        }
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(new XSInteger(), 1));
        }
        return _expected_args;
    }
}

