/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.function.MathDiv;
import info.fingo.xactus.processor.internal.function.MathPlus;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSDouble;
import info.fingo.xactus.processor.internal.types.XSFloat;
import info.fingo.xactus.processor.internal.types.XSInteger;
import info.fingo.xactus.processor.internal.utils.ScalarTypePromoter;
import java.math.BigInteger;
import java.util.Collection;

public class FnAvg
extends Function {
    public FnAvg() {
        super(new QName("avg"), 1);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnAvg.avg(args);
    }

    public static ResultSequence avg(Collection args) throws DynamicError {
        ResultSequence arg = (ResultSequence)args.iterator().next();
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        int elems = 0;
        MathPlus total = null;
        ScalarTypePromoter tp = new ScalarTypePromoter();
        tp.considerSequence(arg);
        for (Item next : arg) {
            ++elems;
            AnyAtomicType conv = tp.promote((AnyType)next);
            if (conv == null) continue;
            if (conv instanceof XSDouble && ((XSDouble)conv).nan() || conv instanceof XSFloat && ((XSFloat)conv).nan()) {
                return tp.promote(new XSFloat(Float.NaN));
            }
            if (total == null) {
                total = (MathPlus)((Object)conv);
                continue;
            }
            total = (MathPlus)((Object)total.plus(conv).first());
        }
        if (!(total instanceof MathDiv)) {
            DynamicError.throw_type_error();
        }
        return ((MathDiv)((Object)total)).div(new XSInteger(BigInteger.valueOf(elems)));
    }

    @Override
    public TypeDefinition getResultType() {
        return super.getResultType();
    }
}

