/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.ast;

import info.fingo.xactus.processor.StaticError;
import info.fingo.xactus.processor.internal.AttributeAxis;
import info.fingo.xactus.processor.internal.ChildAxis;
import info.fingo.xactus.processor.internal.DescendantAxis;
import info.fingo.xactus.processor.internal.DescendantOrSelfAxis;
import info.fingo.xactus.processor.internal.FollowingAxis;
import info.fingo.xactus.processor.internal.FollowingSiblingAxis;
import info.fingo.xactus.processor.internal.ForwardAxis;
import info.fingo.xactus.processor.internal.SelfAxis;
import info.fingo.xactus.processor.internal.ast.AttributeTest;
import info.fingo.xactus.processor.internal.ast.NodeTest;
import info.fingo.xactus.processor.internal.ast.Step;
import info.fingo.xactus.processor.internal.ast.XPathVisitor;

public class ForwardStep
extends Step {
    public static final int NONE = 0;
    public static final int CHILD = 1;
    public static final int DESCENDANT = 2;
    public static final int ATTRIBUTE = 3;
    public static final int SELF = 4;
    public static final int DESCENDANT_OR_SELF = 5;
    public static final int FOLLOWING_SIBLING = 6;
    public static final int FOLLOWING = 7;
    public static final int NAMESPACE = 8;
    public static final int AT_SYM = 9;
    private int _axis;
    private ForwardAxis _iterator;

    private void update_iterator() {
        switch (this._axis) {
            case 0: {
                if (this.node_test() instanceof AttributeTest) {
                    this._iterator = new AttributeAxis();
                    break;
                }
                this._iterator = new ChildAxis();
                break;
            }
            case 1: {
                this._iterator = new ChildAxis();
                break;
            }
            case 2: {
                this._iterator = new DescendantAxis();
                break;
            }
            case 6: {
                this._iterator = new FollowingSiblingAxis();
                break;
            }
            case 7: {
                this._iterator = new FollowingAxis();
                break;
            }
            case 3: 
            case 9: {
                this._iterator = new AttributeAxis();
                break;
            }
            case 4: {
                this._iterator = new SelfAxis();
                break;
            }
            case 5: {
                this._iterator = new DescendantOrSelfAxis();
                break;
            }
            case 8: {
                throw new StaticError("XPST0010", "namespace axis not implemented");
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public ForwardStep(int axis, NodeTest node_test) {
        super(node_test);
        this._axis = axis;
        this.update_iterator();
    }

    @Override
    public Object accept(XPathVisitor v) {
        return v.visit(this);
    }

    public int axis() {
        return this._axis;
    }

    public void set_axis(int axis) {
        this._axis = axis;
        this.update_iterator();
    }

    public ForwardAxis iterator() {
        return this._iterator;
    }
}

