/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal;

import info.fingo.xactus.processor.StaticContext;
import info.fingo.xactus.processor.ast.XPath;
import info.fingo.xactus.processor.internal.ast.AddExpr;
import info.fingo.xactus.processor.internal.ast.AndExpr;
import info.fingo.xactus.processor.internal.ast.AnyKindTest;
import info.fingo.xactus.processor.internal.ast.AttributeTest;
import info.fingo.xactus.processor.internal.ast.AxisStep;
import info.fingo.xactus.processor.internal.ast.BinExpr;
import info.fingo.xactus.processor.internal.ast.CastExpr;
import info.fingo.xactus.processor.internal.ast.CastableExpr;
import info.fingo.xactus.processor.internal.ast.CmpExpr;
import info.fingo.xactus.processor.internal.ast.CntxItemExpr;
import info.fingo.xactus.processor.internal.ast.CommentTest;
import info.fingo.xactus.processor.internal.ast.DecimalLiteral;
import info.fingo.xactus.processor.internal.ast.DivExpr;
import info.fingo.xactus.processor.internal.ast.DocumentTest;
import info.fingo.xactus.processor.internal.ast.DoubleLiteral;
import info.fingo.xactus.processor.internal.ast.ElementTest;
import info.fingo.xactus.processor.internal.ast.ExceptExpr;
import info.fingo.xactus.processor.internal.ast.Expr;
import info.fingo.xactus.processor.internal.ast.FilterExpr;
import info.fingo.xactus.processor.internal.ast.ForExpr;
import info.fingo.xactus.processor.internal.ast.ForwardStep;
import info.fingo.xactus.processor.internal.ast.FunctionCall;
import info.fingo.xactus.processor.internal.ast.IDivExpr;
import info.fingo.xactus.processor.internal.ast.IfExpr;
import info.fingo.xactus.processor.internal.ast.InstOfExpr;
import info.fingo.xactus.processor.internal.ast.IntegerLiteral;
import info.fingo.xactus.processor.internal.ast.IntersectExpr;
import info.fingo.xactus.processor.internal.ast.ItemType;
import info.fingo.xactus.processor.internal.ast.MinusExpr;
import info.fingo.xactus.processor.internal.ast.ModExpr;
import info.fingo.xactus.processor.internal.ast.MulExpr;
import info.fingo.xactus.processor.internal.ast.NameTest;
import info.fingo.xactus.processor.internal.ast.NodeTest;
import info.fingo.xactus.processor.internal.ast.OrExpr;
import info.fingo.xactus.processor.internal.ast.PITest;
import info.fingo.xactus.processor.internal.ast.ParExpr;
import info.fingo.xactus.processor.internal.ast.PipeExpr;
import info.fingo.xactus.processor.internal.ast.PlusExpr;
import info.fingo.xactus.processor.internal.ast.PrimaryExpr;
import info.fingo.xactus.processor.internal.ast.QuantifiedExpr;
import info.fingo.xactus.processor.internal.ast.RangeExpr;
import info.fingo.xactus.processor.internal.ast.ReverseStep;
import info.fingo.xactus.processor.internal.ast.SchemaAttrTest;
import info.fingo.xactus.processor.internal.ast.SchemaElemTest;
import info.fingo.xactus.processor.internal.ast.SequenceType;
import info.fingo.xactus.processor.internal.ast.SingleType;
import info.fingo.xactus.processor.internal.ast.Step;
import info.fingo.xactus.processor.internal.ast.StepExpr;
import info.fingo.xactus.processor.internal.ast.StringLiteral;
import info.fingo.xactus.processor.internal.ast.SubExpr;
import info.fingo.xactus.processor.internal.ast.TextTest;
import info.fingo.xactus.processor.internal.ast.TreatAsExpr;
import info.fingo.xactus.processor.internal.ast.UnExpr;
import info.fingo.xactus.processor.internal.ast.UnionExpr;
import info.fingo.xactus.processor.internal.ast.VarExprPair;
import info.fingo.xactus.processor.internal.ast.VarRef;
import info.fingo.xactus.processor.internal.ast.XPathExpr;
import info.fingo.xactus.processor.internal.ast.XPathNode;
import info.fingo.xactus.processor.internal.ast.XPathVisitor;
import info.fingo.xactus.processor.internal.types.QName;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class Normalizer
implements XPathVisitor {
    private final StaticContext sc;

    public Normalizer(StaticContext sc) {
        this.sc = sc;
    }

    @Override
    public Object visit(XPath xp) {
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        for (Expr e : xp) {
            Expr n = (Expr)e.accept(this);
            exprs.add(n);
        }
        return new XPath(exprs);
    }

    @Override
    public Object visit(ForExpr fex) {
        ForExpr last = fex;
        Expr ret = fex.expr();
        int depth = 0;
        for (VarExprPair ve : fex) {
            if (depth > 0) {
                ArrayList<VarExprPair> pairs = new ArrayList<VarExprPair>();
                pairs.add(ve);
                ForExpr fe = new ForExpr(pairs, ret);
                last.set_expr(fe);
                last = fe;
            }
            ++depth;
        }
        ret.accept(this);
        if (depth > 1) {
            fex.truncate_pairs();
        }
        return fex;
    }

    @Override
    public Object visit(QuantifiedExpr qex) {
        QuantifiedExpr last = qex;
        Expr ret = qex.expr();
        int depth = 0;
        for (VarExprPair ve : qex) {
            if (depth > 0) {
                ArrayList<VarExprPair> pairs = new ArrayList<VarExprPair>();
                pairs.add(ve);
                QuantifiedExpr qe = new QuantifiedExpr(qex.type(), pairs, ret);
                last.set_expr(qe);
                last = qe;
            }
            ++depth;
        }
        ret.accept(this);
        if (depth > 1) {
            qex.truncate_pairs();
        }
        return qex;
    }

    private void printExprs(Iterable<Expr> i) {
        for (Expr e : i) {
            e.accept(this);
        }
    }

    @Override
    public Object visit(IfExpr ifex) {
        this.printExprs(ifex);
        ifex.then_clause().accept(this);
        ifex.else_clause().accept(this);
        return ifex;
    }

    public void printBinExpr(String name, BinExpr e) {
        e.left().accept(this);
        e.right().accept(this);
    }

    private BinExpr make_logic_expr(BinExpr e) {
        Collection<Expr> normalized = this.normalize_bin_args(e);
        Expr[] nor_arr = new Expr[2];
        int j = 0;
        Iterator<Expr> iterator = normalized.iterator();
        while (iterator.hasNext()) {
            Expr i;
            nor_arr[j] = i = iterator.next();
            ++j;
        }
        ArrayList<Expr> args = new ArrayList<Expr>();
        args.add(nor_arr[0]);
        e.set_left(this.make_function(new QName("fn", "boolean", "http://www.w3.org/2005/xpath-functions"), args));
        args.clear();
        args.add(nor_arr[1]);
        e.set_right(this.make_function(new QName("fn", "boolean", "http://www.w3.org/2005/xpath-functions"), args));
        return e;
    }

    @Override
    public Object visit(OrExpr orex) {
        return this.make_logic_expr(orex);
    }

    @Override
    public Object visit(AndExpr andex) {
        return this.make_logic_expr(andex);
    }

    @Override
    public Object visit(CmpExpr cmpex) {
        switch (cmpex.type()) {
            case 6: {
                return this.make_CmpOp(cmpex, new QName("fs", "eq", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 7: {
                return this.make_CmpOp(cmpex, new QName("fs", "ne", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 8: {
                return this.make_CmpOp(cmpex, new QName("fs", "lt", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 10: {
                return this.make_CmpOp(cmpex, new QName("fs", "gt", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 9: {
                return this.make_CmpOp(cmpex, new QName("fs", "le", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 11: {
                return this.make_CmpOp(cmpex, new QName("fs", "ge", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
            }
            case 12: {
                return this.make_function(new QName("op", "node-equal"), this.normalize_bin_args(cmpex));
            }
            case 13: {
                return this.make_function(new QName("op", "node-before"), this.normalize_bin_args(cmpex));
            }
            case 14: {
                return this.make_function(new QName("op", "node-after"), this.normalize_bin_args(cmpex));
            }
        }
        this.printBinExpr("CMP" + cmpex.type(), cmpex);
        return cmpex;
    }

    private Collection<Expr> normalize_bin_args(BinExpr e) {
        Expr left = (Expr)e.left().accept(this);
        Expr right = (Expr)e.right().accept(this);
        ArrayList<Expr> args = new ArrayList<Expr>();
        args.add(left);
        args.add(right);
        return args;
    }

    @Override
    public Object visit(RangeExpr rex) {
        Collection<Expr> args = this.normalize_bin_args(rex);
        return this.make_function(new QName("op", "to", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    private XPathExpr make_xpathexpr(PrimaryExpr pex) {
        FilterExpr fe = new FilterExpr(pex, Collections.emptyList());
        return new XPathExpr(0, fe);
    }

    private XPathExpr make_int_lit(int i) {
        IntegerLiteral il = new IntegerLiteral(BigInteger.valueOf(i));
        return this.make_xpathexpr(il);
    }

    private XPathExpr make_string_lit(String s) {
        StringLiteral sl = new StringLiteral(s);
        return this.make_xpathexpr(sl);
    }

    private XPathExpr make_convert_operand(XPathExpr arg1, XPathExpr arg2) {
        ArrayList<Expr> args = new ArrayList<Expr>();
        args.add(arg1);
        args.add(arg2);
        return this.make_function(new QName("fs", "convert-operand", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    private XPathExpr make_double_lit(double d) {
        DoubleLiteral dl = new DoubleLiteral(d);
        return this.make_xpathexpr(dl);
    }

    private XPathExpr make_convert_binop(BinExpr e, XPathExpr convarg, QName name) {
        Collection<Expr> args = this.normalize_bin_args(e);
        XPathExpr[] args_arr = new XPathExpr[2];
        int j = 0;
        for (XPathNode xPathNode : args) {
            args_arr[j] = (XPathExpr)xPathNode;
            ++j;
        }
        ArrayList<Expr> argsfname = new ArrayList<Expr>();
        for (j = 0; j < 2; ++j) {
            XPathExpr xPathExpr = this.make_convert_operand(args_arr[j], convarg);
            argsfname.add(xPathExpr);
        }
        return this.make_function(name, argsfname);
    }

    private XPathExpr make_ArithOp(BinExpr e, QName name) {
        return this.make_convert_binop(e, this.make_double_lit(1.0), name);
    }

    private XPathExpr make_CmpOp(BinExpr e, QName name) {
        return this.make_convert_binop(e, this.make_string_lit("string"), name);
    }

    @Override
    public Object visit(AddExpr addex) {
        return this.make_ArithOp(addex, new QName("fs", "plus", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    @Override
    public Object visit(SubExpr subex) {
        return this.make_ArithOp(subex, new QName("fs", "minus", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    @Override
    public Object visit(MulExpr mulex) {
        return this.make_ArithOp(mulex, new QName("fs", "times", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    @Override
    public Object visit(DivExpr mulex) {
        return this.make_ArithOp(mulex, new QName("fs", "div", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    @Override
    public Object visit(IDivExpr mulex) {
        return this.make_ArithOp(mulex, new QName("fs", "idiv", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    @Override
    public Object visit(ModExpr mulex) {
        return this.make_ArithOp(mulex, new QName("fs", "mod", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"));
    }

    @Override
    public Object visit(UnionExpr unex) {
        Collection<Expr> args = this.normalize_bin_args(unex);
        return this.make_function(new QName("op", "union", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    @Override
    public Object visit(PipeExpr pipex) {
        Collection<Expr> args = this.normalize_bin_args(pipex);
        return this.make_function(new QName("op", "union", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    @Override
    public Object visit(IntersectExpr iexpr) {
        Collection<Expr> args = this.normalize_bin_args(iexpr);
        return this.make_function(new QName("op", "intersect", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    @Override
    public Object visit(ExceptExpr eexpr) {
        Collection<Expr> args = this.normalize_bin_args(eexpr);
        return this.make_function(new QName("op", "except", "http://www.w3.org/TR/2003/WD-xquery-semantics-20030502/"), args);
    }

    @Override
    public Object visit(InstOfExpr ioexp) {
        this.printBinExpr("INSTANCEOF", ioexp);
        return ioexp;
    }

    @Override
    public Object visit(TreatAsExpr taexp) {
        this.printBinExpr("TREATAS", taexp);
        return taexp;
    }

    @Override
    public Object visit(CastableExpr cexp) {
        this.printBinExpr("CASTABLE", cexp);
        return cexp;
    }

    @Override
    public Object visit(CastExpr cexp) {
        this.printBinExpr("CAST", cexp);
        return cexp;
    }

    public void printUnExpr(String name, UnExpr e) {
        e.arg().accept(this);
    }

    @Override
    public Object visit(MinusExpr e) {
        SubExpr se = new SubExpr(this.make_int_lit(0), e.arg());
        return se.accept(this);
    }

    @Override
    public Object visit(PlusExpr e) {
        AddExpr ae = new AddExpr(this.make_int_lit(0), e.arg());
        return ae.accept(this);
    }

    private XPathExpr make_function(QName name, Collection<Expr> args) {
        FunctionCall fc = new FunctionCall(name, args);
        FilterExpr fe = new FilterExpr(fc, Collections.emptyList());
        return new XPathExpr(0, fe);
    }

    private XPathExpr make_root_self_node() {
        ForwardStep self_node = new ForwardStep(4, new AnyKindTest());
        AxisStep self_node_expr = new AxisStep(self_node, Collections.emptyList());
        XPathExpr self_node_xpath = new XPathExpr(0, self_node_expr);
        ArrayList<Expr> args = new ArrayList<Expr>();
        args.add(self_node_xpath);
        XPathExpr xpe = this.make_function(new QName("fn", "root", "http://www.w3.org/2005/xpath-functions"), args);
        return xpe;
    }

    private XPathExpr make_descendant_or_self() {
        ForwardStep desc_self_node = new ForwardStep(5, new AnyKindTest());
        AxisStep se = new AxisStep(desc_self_node, Collections.emptyList());
        return new XPathExpr(0, se);
    }

    @Override
    public Object visit(XPathExpr e) {
        XPathExpr xp = e;
        int depth = 0;
        XPathExpr result = e;
        while (xp != null) {
            XPathExpr next;
            int slashes = xp.slashes();
            StepExpr se = xp.expr();
            if (slashes == 1) {
                if (se == null) {
                    return this.make_root_self_node();
                }
                if (depth == 0) {
                    XPathExpr xpe = this.make_root_self_node();
                    xpe.set_next(e);
                    result = xpe;
                }
            }
            if (slashes == 2 && depth == 0) {
                XPathExpr desc = this.make_descendant_or_self();
                desc.set_slashes(1);
                e.set_slashes(1);
                desc.set_next(e);
                XPathExpr root_self = this.make_root_self_node();
                root_self.set_next(desc);
                return root_self;
            }
            if (se != null) {
                se.accept(this);
            }
            if ((next = xp.next()) != null && next.slashes() == 2) {
                XPathExpr desc = this.make_descendant_or_self();
                desc.set_slashes(1);
                xp.set_next(desc);
                desc.set_next(next);
                next.set_slashes(1);
            }
            xp = next;
            ++depth;
        }
        return result;
    }

    @Override
    public Object visit(ForwardStep e) {
        int axis = e.axis();
        switch (axis) {
            case 9: {
                e.set_axis(3);
                break;
            }
            case 0: {
                e.set_axis(1);
            }
        }
        e.node_test().accept(this);
        return e;
    }

    @Override
    public Object visit(ReverseStep e) {
        if (e.axis() == 5) {
            AnyKindTest nt = new AnyKindTest();
            ReverseStep s = new ReverseStep(0, nt);
            return s;
        }
        NodeTest nt = e.node_test();
        if (nt != null) {
            nt.accept(this);
        }
        return e;
    }

    @Override
    public Object visit(NameTest e) {
        String prefix = e.name().prefix();
        if (prefix == null) {
            return null;
        }
        return e;
    }

    @Override
    public Object visit(VarRef e) {
        return e;
    }

    @Override
    public Object visit(StringLiteral e) {
        return e;
    }

    @Override
    public Object visit(IntegerLiteral e) {
        return e;
    }

    @Override
    public Object visit(DoubleLiteral e) {
        return e;
    }

    @Override
    public Object visit(DecimalLiteral e) {
        return e;
    }

    @Override
    public Object visit(ParExpr e) {
        this.printExprs(e);
        return e;
    }

    @Override
    public Object visit(CntxItemExpr e) {
        return new VarRef(new QName("fs", "dot"));
    }

    @Override
    public Object visit(FunctionCall e) {
        this.printExprs(e);
        return e;
    }

    @Override
    public Object visit(SingleType e) {
        return e;
    }

    @Override
    public Object visit(SequenceType e) {
        ItemType it = e.item_type();
        if (it != null) {
            it.accept(this);
        }
        return e;
    }

    @Override
    public Object visit(ItemType e) {
        switch (e.type()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                e.kind_test().accept(this);
            }
        }
        return e;
    }

    @Override
    public Object visit(AnyKindTest e) {
        return e;
    }

    @Override
    public Object visit(DocumentTest e) {
        switch (e.type()) {
            case 1: {
                e.elem_test().accept(this);
                break;
            }
            case 2: {
                e.schema_elem_test().accept(this);
            }
        }
        return e;
    }

    @Override
    public Object visit(TextTest e) {
        return e;
    }

    @Override
    public Object visit(CommentTest e) {
        return e;
    }

    @Override
    public Object visit(PITest e) {
        String arg = e.arg();
        if (arg == null) {
            arg = "";
        }
        return e;
    }

    @Override
    public Object visit(AttributeTest e) {
        return e;
    }

    @Override
    public Object visit(SchemaAttrTest e) {
        return e;
    }

    @Override
    public Object visit(ElementTest e) {
        return e;
    }

    @Override
    public Object visit(SchemaElemTest e) {
        return e;
    }

    private void printCollExprs(Iterable<Collection<Expr>> i) {
        for (Collection<Expr> coll : i) {
            this.printExprs(coll);
        }
    }

    @Override
    public Object visit(AxisStep as) {
        Step s = (Step)as.step().accept(this);
        as.set_step(s);
        this.printCollExprs(as);
        return as;
    }

    @Override
    public Object visit(FilterExpr fe) {
        PrimaryExpr pe = (PrimaryExpr)fe.primary().accept(this);
        fe.set_primary(pe);
        this.printCollExprs(fe);
        return fe;
    }
}

