/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor;

import info.fingo.xactus.api.Function;
import info.fingo.xactus.processor.StaticChecker;
import info.fingo.xactus.processor.StaticContext;
import info.fingo.xactus.processor.StaticError;
import info.fingo.xactus.processor.ast.XPath;
import info.fingo.xactus.processor.internal.ReverseAxis;
import info.fingo.xactus.processor.internal.StaticAttrNameError;
import info.fingo.xactus.processor.internal.StaticContextAdapter;
import info.fingo.xactus.processor.internal.StaticElemNameError;
import info.fingo.xactus.processor.internal.StaticFunctNameError;
import info.fingo.xactus.processor.internal.StaticNameError;
import info.fingo.xactus.processor.internal.StaticNsNameError;
import info.fingo.xactus.processor.internal.StaticTypeNameError;
import info.fingo.xactus.processor.internal.ast.AddExpr;
import info.fingo.xactus.processor.internal.ast.AndExpr;
import info.fingo.xactus.processor.internal.ast.AnyKindTest;
import info.fingo.xactus.processor.internal.ast.AttributeTest;
import info.fingo.xactus.processor.internal.ast.AxisStep;
import info.fingo.xactus.processor.internal.ast.BinExpr;
import info.fingo.xactus.processor.internal.ast.CastExpr;
import info.fingo.xactus.processor.internal.ast.CastableExpr;
import info.fingo.xactus.processor.internal.ast.CmpExpr;
import info.fingo.xactus.processor.internal.ast.CntxItemExpr;
import info.fingo.xactus.processor.internal.ast.CommentTest;
import info.fingo.xactus.processor.internal.ast.DecimalLiteral;
import info.fingo.xactus.processor.internal.ast.DivExpr;
import info.fingo.xactus.processor.internal.ast.DocumentTest;
import info.fingo.xactus.processor.internal.ast.DoubleLiteral;
import info.fingo.xactus.processor.internal.ast.ElementTest;
import info.fingo.xactus.processor.internal.ast.ExceptExpr;
import info.fingo.xactus.processor.internal.ast.Expr;
import info.fingo.xactus.processor.internal.ast.FilterExpr;
import info.fingo.xactus.processor.internal.ast.ForExpr;
import info.fingo.xactus.processor.internal.ast.ForwardStep;
import info.fingo.xactus.processor.internal.ast.FunctionCall;
import info.fingo.xactus.processor.internal.ast.IDivExpr;
import info.fingo.xactus.processor.internal.ast.IfExpr;
import info.fingo.xactus.processor.internal.ast.InstOfExpr;
import info.fingo.xactus.processor.internal.ast.IntegerLiteral;
import info.fingo.xactus.processor.internal.ast.IntersectExpr;
import info.fingo.xactus.processor.internal.ast.ItemType;
import info.fingo.xactus.processor.internal.ast.MinusExpr;
import info.fingo.xactus.processor.internal.ast.ModExpr;
import info.fingo.xactus.processor.internal.ast.MulExpr;
import info.fingo.xactus.processor.internal.ast.NameTest;
import info.fingo.xactus.processor.internal.ast.NodeTest;
import info.fingo.xactus.processor.internal.ast.OrExpr;
import info.fingo.xactus.processor.internal.ast.PITest;
import info.fingo.xactus.processor.internal.ast.ParExpr;
import info.fingo.xactus.processor.internal.ast.PipeExpr;
import info.fingo.xactus.processor.internal.ast.PlusExpr;
import info.fingo.xactus.processor.internal.ast.PrimaryExpr;
import info.fingo.xactus.processor.internal.ast.QuantifiedExpr;
import info.fingo.xactus.processor.internal.ast.RangeExpr;
import info.fingo.xactus.processor.internal.ast.ReverseStep;
import info.fingo.xactus.processor.internal.ast.SchemaAttrTest;
import info.fingo.xactus.processor.internal.ast.SchemaElemTest;
import info.fingo.xactus.processor.internal.ast.SequenceType;
import info.fingo.xactus.processor.internal.ast.SingleType;
import info.fingo.xactus.processor.internal.ast.StepExpr;
import info.fingo.xactus.processor.internal.ast.StringLiteral;
import info.fingo.xactus.processor.internal.ast.SubExpr;
import info.fingo.xactus.processor.internal.ast.TextTest;
import info.fingo.xactus.processor.internal.ast.TreatAsExpr;
import info.fingo.xactus.processor.internal.ast.UnExpr;
import info.fingo.xactus.processor.internal.ast.UnionExpr;
import info.fingo.xactus.processor.internal.ast.VarExprPair;
import info.fingo.xactus.processor.internal.ast.VarRef;
import info.fingo.xactus.processor.internal.ast.XPathExpr;
import info.fingo.xactus.processor.internal.ast.XPathNode;
import info.fingo.xactus.processor.internal.ast.XPathVisitor;
import info.fingo.xactus.processor.internal.function.XSQNameConstructor;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.SimpleAtomicItemTypeImpl;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeDefinition;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class StaticNameResolver
implements XPathVisitor,
StaticChecker {
    private info.fingo.xactus.api.StaticContext _sc;
    private StaticNameError _err;
    private Set<javax.xml.namespace.QName> _resolvedFunctions = new HashSet<javax.xml.namespace.QName>();
    private Set<String> _axes = new HashSet<String>();
    private Set<javax.xml.namespace.QName> _freeVariables = new HashSet<javax.xml.namespace.QName>();
    private VariableScope _innerScope = null;
    private boolean _rootUsed;

    public StaticNameResolver(StaticContext sc) {
        this._sc = new StaticContextAdapter(sc);
        this._err = null;
    }

    public StaticNameResolver(info.fingo.xactus.api.StaticContext context) {
        this._sc = context;
        this._err = null;
    }

    public Set<String> getAxes() {
        return this._axes;
    }

    public Set<javax.xml.namespace.QName> getFreeVariables() {
        return this._freeVariables;
    }

    public Set<javax.xml.namespace.QName> getResolvedFunctions() {
        return this._resolvedFunctions;
    }

    private info.fingo.xactus.api.typesystem.ItemType getVariableType(QName name) {
        VariableScope scope = this._innerScope;
        while (scope != null) {
            if (name.equals(scope.name)) {
                return scope.typeDef;
            }
            scope = scope.nextScope;
        }
        return this._sc.getInScopeVariables().getVariableType(name.asQName());
    }

    private boolean isVariableCaptured(QName name) {
        VariableScope scope = this._innerScope;
        while (scope != null) {
            if (name.equals(scope.name)) {
                return true;
            }
            scope = scope.nextScope;
        }
        return false;
    }

    private boolean isVariableInScope(QName name) {
        return this.isVariableCaptured(name) || this._sc.getInScopeVariables().isVariablePresent(name.asQName());
    }

    private void popScope() {
        if (this._innerScope == null) {
            throw new IllegalStateException("Unmatched scope pop");
        }
        this._innerScope = this._innerScope.nextScope;
    }

    private void pushScope(QName var, BuiltinTypeDefinition xsAnytype) {
        this._innerScope = new VariableScope(var, new SimpleAtomicItemTypeImpl(xsAnytype), this._innerScope);
    }

    private boolean expandQName(QName name, String def, boolean allowWildcards) {
        String prefix = name.prefix();
        if ("*".equals(prefix)) {
            if (!allowWildcards) {
                return false;
            }
            name.set_namespace("*");
            return true;
        }
        if (prefix == null || "".equals(prefix)) {
            name.set_namespace(def);
            return true;
        }
        String namespaceURI = this._sc.getNamespaceContext().getNamespaceURI(prefix);
        if ("".equals(namespaceURI)) {
            return false;
        }
        name.set_namespace(namespaceURI);
        return true;
    }

    private boolean expandItemQName(QName name) {
        return this.expandQName(name, this._sc.getDefaultNamespace(), true);
    }

    private boolean expandVarQName(QName name) {
        return this.expandQName(name, null, false);
    }

    private boolean expandFunctionQName(QName name) {
        return this.expandQName(name, this._sc.getDefaultFunctionNamespace(), false);
    }

    private boolean expandItemTypeQName(QName name) {
        return this.expandQName(name, this._sc.getDefaultNamespace(), false);
    }

    private void reportError(StaticNameError err) {
        this._err = err;
        throw new DummyError();
    }

    private void reportBadPrefix(String prefix) {
        this.reportError(StaticNsNameError.unknown_prefix(prefix));
    }

    @Override
    public void check(XPathNode node) throws StaticError {
        try {
            node.accept(this);
        }
        catch (DummyError e) {
            throw this._err;
        }
    }

    @Override
    public Object visit(XPath xp) {
        for (Expr e : xp) {
            e.accept(this);
        }
        return null;
    }

    private void doForExpr(Iterable<VarExprPair> iter, Expr expr) {
        int scopes = 0;
        for (VarExprPair pair : iter) {
            QName var = pair.varname();
            if (!this.expandVarQName(var)) {
                this.reportBadPrefix(var.prefix());
            }
            Expr e = pair.expr();
            e.accept(this);
            this.pushScope(var, BuiltinTypeLibrary.XS_ANYTYPE);
            ++scopes;
        }
        expr.accept(this);
        for (int i = 0; i < scopes; ++i) {
            this.popScope();
        }
    }

    @Override
    public Object visit(ForExpr fex) {
        this.doForExpr(fex, fex.expr());
        return null;
    }

    @Override
    public Object visit(QuantifiedExpr qex) {
        this.doForExpr(qex, qex.expr());
        return null;
    }

    private void visitExprs(Iterable<Expr> exps) {
        for (Expr exp : exps) {
            exp.accept(this);
        }
    }

    @Override
    public Object visit(IfExpr ifex) {
        this.visitExprs(ifex);
        ifex.then_clause().accept(this);
        ifex.else_clause().accept(this);
        return null;
    }

    public void printBinExpr(String name, BinExpr e) {
        e.left().accept(this);
        e.right().accept(this);
    }

    @Override
    public Object visit(OrExpr orex) {
        this.printBinExpr("OR", orex);
        return null;
    }

    @Override
    public Object visit(AndExpr andex) {
        this.printBinExpr("AND", andex);
        return null;
    }

    @Override
    public Object visit(CmpExpr cmpex) {
        this.printBinExpr("CMP" + cmpex.type(), cmpex);
        return null;
    }

    @Override
    public Object visit(RangeExpr rex) {
        this.printBinExpr("RANGE", rex);
        return null;
    }

    @Override
    public Object visit(AddExpr addex) {
        this.printBinExpr("ADD", addex);
        return null;
    }

    @Override
    public Object visit(SubExpr subex) {
        this.printBinExpr("SUB", subex);
        return null;
    }

    @Override
    public Object visit(MulExpr mulex) {
        this.printBinExpr("MUL", mulex);
        return null;
    }

    @Override
    public Object visit(DivExpr mulex) {
        this.printBinExpr("DIV", mulex);
        return null;
    }

    @Override
    public Object visit(IDivExpr mulex) {
        this.printBinExpr("IDIV", mulex);
        return null;
    }

    @Override
    public Object visit(ModExpr mulex) {
        this.printBinExpr("MOD", mulex);
        return null;
    }

    @Override
    public Object visit(UnionExpr unex) {
        this.printBinExpr("UNION", unex);
        return null;
    }

    @Override
    public Object visit(PipeExpr pipex) {
        this.printBinExpr("PIPE", pipex);
        return null;
    }

    @Override
    public Object visit(IntersectExpr iexpr) {
        this.printBinExpr("INTERSECT", iexpr);
        return null;
    }

    @Override
    public Object visit(ExceptExpr eexpr) {
        this.printBinExpr("INT_EXCEPT", eexpr);
        return null;
    }

    @Override
    public Object visit(InstOfExpr ioexp) {
        this.printBinExpr("INSTANCEOF", ioexp);
        return null;
    }

    @Override
    public Object visit(TreatAsExpr taexp) {
        this.printBinExpr("TREATAS", taexp);
        return null;
    }

    @Override
    public Object visit(CastableExpr cexp) {
        this.printBinExpr("CASTABLE", cexp);
        return null;
    }

    @Override
    public Object visit(CastExpr cexp) {
        this.printBinExpr("CAST", cexp);
        SingleType st = (SingleType)cexp.right();
        QName type = st.type();
        javax.xml.namespace.QName qName = type.asQName();
        Function f = this._sc.resolveFunction(qName, 1);
        if (f == null) {
            this.reportError(new StaticFunctNameError("Type does not exist: " + type.toString()));
        }
        cexp.set_function(f);
        this._resolvedFunctions.add(qName);
        return null;
    }

    public void printUnExpr(String name, UnExpr e) {
        e.arg().accept(this);
    }

    @Override
    public Object visit(MinusExpr e) {
        this.printUnExpr("MINUS", e);
        return null;
    }

    @Override
    public Object visit(PlusExpr e) {
        this.printUnExpr("PLUS", e);
        return null;
    }

    @Override
    public Object visit(XPathExpr e) {
        boolean firstStep = true;
        for (XPathExpr xp = e; xp != null; xp = xp.next()) {
            if (firstStep && xp.slashes() != 0) {
                this._rootUsed = true;
            }
            firstStep = false;
            StepExpr se = xp.expr();
            if (se == null) continue;
            se.accept(this);
        }
        return null;
    }

    @Override
    public Object visit(ForwardStep e) {
        e.node_test().accept(this);
        this._axes.add(e.iterator().name());
        return null;
    }

    @Override
    public Object visit(ReverseStep e) {
        ReverseAxis iterator;
        NodeTest nt = e.node_test();
        if (nt != null) {
            nt.accept(this);
        }
        if ((iterator = e.iterator()) != null) {
            this._axes.add(iterator.name());
        }
        return null;
    }

    @Override
    public Object visit(NameTest e) {
        QName name = e.name();
        if (!this.expandItemQName(name)) {
            this.reportBadPrefix(name.prefix());
        }
        return null;
    }

    @Override
    public Object visit(VarRef e) {
        QName var = e.name();
        if (!this.expandVarQName(var)) {
            this.reportBadPrefix(var.prefix());
        }
        if (!this.isVariableInScope(var)) {
            this.reportError(new StaticNameError("Variable not declared: " + var.string()));
        }
        if (this.getVariableType(var) == null) {
            this.reportError(new StaticNameError("Variable not declared: " + var.string()));
        }
        if (!this.isVariableCaptured(var)) {
            this._freeVariables.add(var.asQName());
        }
        return null;
    }

    @Override
    public Object visit(StringLiteral e) {
        return null;
    }

    @Override
    public Object visit(IntegerLiteral e) {
        return null;
    }

    @Override
    public Object visit(DoubleLiteral e) {
        return null;
    }

    @Override
    public Object visit(DecimalLiteral e) {
        return null;
    }

    @Override
    public Object visit(ParExpr pe) {
        this.visitExprs(pe);
        return null;
    }

    @Override
    public Object visit(CntxItemExpr e) {
        return null;
    }

    @Override
    public Object visit(FunctionCall fc) {
        javax.xml.namespace.QName qName;
        Function f;
        QName name = fc.name();
        if (!this.expandFunctionQName(name)) {
            this.reportBadPrefix(name.prefix());
        }
        if ((f = this._sc.resolveFunction(qName = name.asQName(), fc.arity())) == null) {
            this.reportError(new StaticFunctNameError("Function does not exist: " + name.string() + " arity: " + fc.arity()));
        }
        if (qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") && qName.getLocalPart().equalsIgnoreCase("QName")) {
            QName qnameArg;
            StringLiteral stringArgument = this.getStringArgument(fc);
            if (stringArgument == null) {
                this.reportError(new StaticNameError("!", "not string in function"));
            }
            if ((qnameArg = QName.parse_QName(stringArgument.string())).prefix() == null) {
                qnameArg.set_namespace(this._sc.getDefaultNamespace());
            } else {
                String namespaceURI = this._sc.getNamespaceContext().getNamespaceURI(qnameArg.prefix());
                if (namespaceURI == null) {
                    this.reportError(new StaticNameError("!", "unknown uri for prefix: " + qnameArg.prefix()));
                }
                qnameArg.set_namespace(namespaceURI);
            }
            f = new XSQNameConstructor(qnameArg);
        }
        fc.set_function(f);
        this._resolvedFunctions.add(qName);
        this.visitExprs(fc);
        return null;
    }

    private StringLiteral getStringArgument(FunctionCall e) {
        PrimaryExpr primary;
        StepExpr exp;
        Expr arg1 = e.iterator().next();
        if (arg1 instanceof XPathExpr && ((XPathExpr)arg1).expr() instanceof FilterExpr && (exp = ((XPathExpr)arg1).expr()) instanceof FilterExpr && (primary = ((FilterExpr)exp).primary()) instanceof StringLiteral) {
            return (StringLiteral)primary;
        }
        return null;
    }

    @Override
    public Object visit(SingleType e) {
        QName type = e.type();
        if (!this.expandItemTypeQName(type)) {
            this.reportBadPrefix(type.prefix());
        }
        return null;
    }

    @Override
    public Object visit(SequenceType e) {
        ItemType it = e.item_type();
        if (it != null) {
            it.accept(this);
        }
        return null;
    }

    @Override
    public Object visit(ItemType e) {
        switch (e.type()) {
            case 0: {
                break;
            }
            case 1: {
                QName type = e.qname();
                if (!this.expandItemTypeQName(type)) {
                    this.reportBadPrefix(type.prefix());
                }
                if (BuiltinTypeLibrary.BUILTIN_TYPES.lookupType(e.qname().namespace(), e.qname().local()) != null || this._sc.getTypeModel() != null && this._sc.getTypeModel().lookupType(e.qname().namespace(), e.qname().local()) != null) break;
                this.reportError(new StaticTypeNameError("Type not defined: " + e.qname().string()));
                break;
            }
            case 2: {
                e.kind_test().accept(this);
            }
        }
        return null;
    }

    @Override
    public Object visit(AnyKindTest e) {
        return null;
    }

    @Override
    public Object visit(DocumentTest e) {
        switch (e.type()) {
            case 1: {
                e.elem_test().accept(this);
                break;
            }
            case 2: {
                e.schema_elem_test().accept(this);
            }
        }
        return null;
    }

    @Override
    public Object visit(TextTest e) {
        return null;
    }

    @Override
    public Object visit(CommentTest e) {
        return null;
    }

    @Override
    public Object visit(PITest e) {
        String arg = e.arg();
        if (arg == null) {
            arg = "";
        }
        return null;
    }

    @Override
    public Object visit(AttributeTest e) {
        QName name = e.name();
        if (name != null && !this.expandItemQName(name)) {
            this.reportBadPrefix(name.prefix());
        }
        if ((name = e.type()) != null && !this.expandItemTypeQName(name)) {
            this.reportBadPrefix(name.prefix());
        }
        return null;
    }

    @Override
    public Object visit(SchemaAttrTest e) {
        QName name = e.arg();
        if (!this.expandItemQName(name)) {
            this.reportBadPrefix(name.prefix());
        }
        if (this._sc.getTypeModel().lookupAttributeDeclaration(name.namespace(), name.local()) == null) {
            this.reportError(new StaticAttrNameError("Attribute not decleared: " + name.string()));
        }
        return null;
    }

    @Override
    public Object visit(ElementTest e) {
        if (e.name() != null && !this.expandItemTypeQName(e.name())) {
            this.reportBadPrefix(e.name().prefix());
        }
        if (e.type() != null && !this.expandItemTypeQName(e.type())) {
            this.reportBadPrefix(e.type().prefix());
        }
        return null;
    }

    @Override
    public Object visit(SchemaElemTest e) {
        QName elem = e.name();
        if (!this.expandItemQName(elem)) {
            this.reportBadPrefix(elem.prefix());
        }
        if (this._sc.getTypeModel().lookupElementDeclaration(elem.namespace(), elem.local()) == null) {
            this.reportError(new StaticElemNameError("Element not declared: " + elem.string()));
        }
        return null;
    }

    private void visitCollExprs(Iterable<Collection<Expr>> i) {
        for (Collection<Expr> exps : i) {
            this.visitExprs(exps);
        }
    }

    @Override
    public Object visit(AxisStep e) {
        e.step().accept(this);
        this.visitCollExprs(e);
        return null;
    }

    @Override
    public Object visit(FilterExpr e) {
        e.primary().accept(this);
        this.visitCollExprs(e);
        return null;
    }

    public boolean isRootUsed() {
        return this._rootUsed;
    }

    class VariableScope {
        public final QName name;
        public final info.fingo.xactus.api.typesystem.ItemType typeDef;
        public final VariableScope nextScope;

        public VariableScope(QName name, info.fingo.xactus.api.typesystem.ItemType typeDef, VariableScope nextScope) {
            this.name = name;
            this.typeDef = typeDef;
            this.nextScope = nextScope;
        }
    }

    static class DummyError
    extends Error {
        private static final long serialVersionUID = 3898564402981741950L;

        DummyError() {
        }
    }
}

