/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.snapshot;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.ibboost.orqa.automation.java.ProxySession;
import org.ibboost.orqa.automation.java.ProxySessionManager;
import org.ibboost.orqa.automation.java.common.ProxyNodeReference;
import org.ibboost.orqa.automation.java.executors.ProxyExecutor;
import org.ibboost.orqa.core.execution.ExecutionContext;
import org.ibboost.orqa.report.snapshot.provider.ScreenshotSnapshotProvider;

public class JavaScreenshotSnapshotProvider
extends ScreenshotSnapshotProvider {
    public String getId() {
        return "java.screenshot";
    }

    public String getDisplayName() {
        return "Java screenshot";
    }

    public boolean handlesSnapshot(String operationId, String executorExtension) {
        return operationId != null && operationId.startsWith("java.");
    }

    public String getFileNameSuffix() {
        return "java-screenshot";
    }

    public List<BufferedImage> getScreenshots(ExecutionContext context) throws Exception {
        ArrayList<BufferedImage> result = new ArrayList<BufferedImage>();
        ProxySession currentSession = ProxySessionManager.INSTANCE.getLastSessionUsedByThisThread();
        if (currentSession == null) {
            return result;
        }
        List images = (List)new ProxyExecutor(){

            @Override
            public Object remoteExecute(ExecutionContext context, Map<String, Object> arguments, ProxySession session, ProxyNodeReference element, UUID operationId) throws Exception {
                return session.getRemote().captureImages(element, "/*", operationId, this.getRemainingTime());
            }
        }.execute(context, new HashMap<String, Object>());
        for (byte[] image : images) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(image);
            result.add(ImageIO.read(inputStream));
        }
        return result;
    }
}

