/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.executors;

import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.ibboost.orqa.automation.java.ProxySession;
import org.ibboost.orqa.automation.java.ProxySessionManager;
import org.ibboost.orqa.core.execution.ExecutionContext;
import org.ibboost.orqa.core.execution.IExecutor;

public class StartExecutor
implements IExecutor {
    public Object execute(ExecutionContext context, Map<String, Object> arguments) throws Exception {
        String command = (String)arguments.get("command");
        String sessionName = (String)arguments.get("session");
        IFileStore pwd = (IFileStore)arguments.get("pwd");
        String jvmPath = (String)arguments.get("jvm");
        Boolean autoClose = (Boolean)arguments.get("autoClose");
        Boolean allowSystemClassLoaderOverride = (Boolean)arguments.get("allowSystemClassLoaderOverride");
        String workingDirectory = pwd instanceof LocalFile ? pwd.toLocalFile(0, null).getPath() : null;
        ProxySession session = ProxySessionManager.INSTANCE.getSession(sessionName);
        if (!(session != null && session.isAlive() && StartExecutor.propertiesMatch(session.getCommand(), command) && StartExecutor.propertiesMatch(session.getWorkingDirectory(), workingDirectory) && StartExecutor.propertiesMatch(session.getGivenJvmPath(), jvmPath))) {
            session = ProxySessionManager.INSTANCE.startSession(sessionName, workingDirectory, jvmPath, command, autoClose, allowSystemClassLoaderOverride);
        }
        ProxySessionManager.INSTANCE.setLastSession(session);
        return session;
    }

    private static boolean propertiesMatch(String p1, String p2) {
        if (p1 == null && p2 == null) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        return p1.equals(p2);
    }
}

