/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.executors;

import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.ibboost.orqa.automation.java.ProxySession;
import org.ibboost.orqa.automation.java.common.ProxyNodeReference;
import org.ibboost.orqa.automation.java.executors.ProxyExecutor;
import org.ibboost.orqa.core.execution.ExecutionContext;

public class ScreenshotExecutor
extends ProxyExecutor {
    @Override
    public Object remoteExecute(ExecutionContext context, Map<String, Object> arguments, ProxySession session, ProxyNodeReference element, UUID operationId) throws Exception {
        IFileStore filePath = (IFileStore)arguments.get("filePath");
        IFileStore directory = filePath.getParent();
        List images = session.getRemote().captureImages(element, (String)arguments.get("target"), operationId, this.getRemainingTime());
        if (images.size() > 0) {
            directory.mkdir(0, null);
        }
        int i = 0;
        while (i < images.size()) {
            IFileStore file = ScreenshotExecutor.createFileName(filePath, i + 1);
            OutputStream output = file.openOutputStream(0, null);
            output.write((byte[])images.get(i));
            output.close();
            context.addArtifact(file);
            ++i;
        }
        return null;
    }

    private static IFileStore createFileName(IFileStore filePath, int fileCount) {
        IPath namePath = Path.fromOSString((String)filePath.getName());
        Object name = namePath.removeFileExtension().toOSString();
        String extension = namePath.getFileExtension();
        if (fileCount > 1) {
            name = (String)name + "-" + fileCount;
        }
        if (extension == null) {
            extension = "png";
        }
        return filePath.getParent().getChild((String)name + "." + extension);
    }

    @Override
    public Long getTimeout() {
        return 60000L;
    }
}

