/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.executors;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.filesystem.IFileStore;
import org.ibboost.orqa.automation.events.exceptions.TargetNotFoundException;
import org.ibboost.orqa.automation.java.ProxySession;
import org.ibboost.orqa.automation.java.common.IAutomationProxy;
import org.ibboost.orqa.automation.java.common.ProxyNodeReference;
import org.ibboost.orqa.automation.java.executors.ProxyExecutor;
import org.ibboost.orqa.core.execution.ExecutionContext;
import org.ibboost.orqa.core.execution.TypeCoercion;
import org.ibboost.orqa.images.FindSubImageExecutor;

public class GetElementFromImage
extends ProxyExecutor {
    @Override
    public Object remoteExecute(ExecutionContext context, Map<String, Object> arguments, ProxySession session, ProxyNodeReference rootElement, UUID operationId) throws Exception {
        String target = (String)arguments.get("target");
        IFileStore image = (IFileStore)arguments.get("imageFile");
        Double threshold = (Double)arguments.get("threshold");
        Integer xOffset = (Integer)arguments.get("x");
        Integer yOffset = (Integer)arguments.get("y");
        JavaSubImageLocation subImage = GetElementFromImage.findImage(image, threshold, target, rootElement, session, operationId, this.getRemainingTime());
        int x = subImage.getX();
        int y = subImage.getY();
        ProxyNodeReference result = session.getRemote().getSubNodeFromLocation(subImage.getReferenceElement(), x += xOffset != null ? xOffset : subImage.getWidth() / 2, y += yOffset != null ? yOffset : subImage.getHeight() / 2, operationId, this.getRemainingTime());
        session.getRemote().freeNodeReference(subImage.getReferenceElement());
        if (result == null) {
            throw new TargetNotFoundException(String.format("%s at %s", image, target));
        }
        return result;
    }

    public static JavaSubImageLocation findImage(IFileStore image, Double threshold, String target, ProxyNodeReference rootElement, ProxySession session, UUID operationId, Long timeout) throws Exception {
        long startTime = System.currentTimeMillis();
        IAutomationProxy runner = session.getRemote();
        List targetElements = runner.getNodesFromXPath(rootElement, target, false, operationId, GetElementFromImage.getRemainingTime(timeout, startTime));
        for (ProxyNodeReference targetElement : targetElements) {
            File screenshot = null;
            try {
                byte[] nodeImageData = runner.captureNodeImage(targetElement, operationId, GetElementFromImage.getRemainingTime(timeout, startTime));
                screenshot = File.createTempFile("java-image", null).getAbsoluteFile();
                IFileStore screenshotFileStore = (IFileStore)TypeCoercion.coerce((Object)screenshot, IFileStore.class);
                screenshotFileStore.getParent().mkdir(0, null);
                OutputStream output = screenshotFileStore.openOutputStream(0, null);
                output.write(nodeImageData);
                output.close();
                FindSubImageExecutor.SubImageLocation subImage = FindSubImageExecutor.findSubImage((IFileStore)screenshotFileStore, (IFileStore)image, (Double)threshold, (String)"Windows Screenshot", (String)image.getName());
                JavaSubImageLocation javaSubImageLocation = new JavaSubImageLocation(subImage.getX(), subImage.getY(), subImage.getWidth(), subImage.getHeight(), subImage.getConfidence(), targetElement);
                return javaSubImageLocation;
            }
            catch (Exception e) {
                runner.freeNodeReference(targetElement);
                if (!(e instanceof IOException)) continue;
                throw e;
            }
            finally {
                try {
                    if (screenshot != null) {
                        screenshot.delete();
                    }
                }
                catch (Exception exception) {}
            }
        }
        throw new ImageNotFoundException(image.getName());
    }

    public static class ImageNotFoundException
    extends Exception {
        private static final long serialVersionUID = 3417414841412003411L;

        public ImageNotFoundException(String imageName) {
            super(String.format("Could not find image '%s' in java app.", imageName));
        }
    }

    public static class JavaSubImageLocation
    extends FindSubImageExecutor.SubImageLocation {
        private static final long serialVersionUID = 2715617519546634292L;
        private final ProxyNodeReference referenceElement;

        public JavaSubImageLocation(int x, int y, int width, int height, double confidence, ProxyNodeReference referenceElement) {
            super(x, y, width, height, confidence);
            this.referenceElement = referenceElement;
        }

        public ProxyNodeReference getReferenceElement() {
            return this.referenceElement;
        }
    }
}

