/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.executors;

import java.awt.Rectangle;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.filesystem.IFileStore;
import org.ibboost.orqa.automation.events.enums.AutomatableClick;
import org.ibboost.orqa.automation.java.ProxySession;
import org.ibboost.orqa.automation.java.common.IAutomationProxy;
import org.ibboost.orqa.automation.java.common.ProxyNodeReference;
import org.ibboost.orqa.automation.java.executors.GetElementFromImage;
import org.ibboost.orqa.automation.java.executors.ProxyExecutor;
import org.ibboost.orqa.core.execution.ExecutionContext;

public class ClickOnImage
extends ProxyExecutor {
    @Override
    public Object remoteExecute(ExecutionContext context, Map<String, Object> arguments, ProxySession session, ProxyNodeReference element, UUID operationId) throws Exception {
        AutomatableClick clickType = (AutomatableClick)arguments.get("clickType");
        String target = (String)arguments.get("target");
        IFileStore image = (IFileStore)arguments.get("imageFile");
        Double threshold = (Double)arguments.get("threshold");
        Integer xOffset = (Integer)arguments.get("x");
        Integer yOffset = (Integer)arguments.get("y");
        boolean shift = (Boolean)arguments.get("shift");
        boolean ctrl = (Boolean)arguments.get("ctrl");
        boolean alt = (Boolean)arguments.get("alt");
        IAutomationProxy remote = session.getRemote();
        ProxyNodeReference imageElement = null;
        ProxyNodeReference targetElement = null;
        try {
            GetElementFromImage.JavaSubImageLocation subImage = GetElementFromImage.findImage(image, threshold, target, element, session, operationId, this.getRemainingTime());
            imageElement = subImage.getReferenceElement();
            Rectangle imageBounds = remote.getNodeWindowRelativeBounds(subImage.getReferenceElement(), operationId);
            int imageRelativeClickPointX = subImage.getX() + (xOffset == null ? subImage.getWidth() / 2 : Math.min(subImage.getWidth(), Math.max(0, xOffset)));
            int imageRelativeClickPointY = subImage.getY() + (yOffset == null ? subImage.getHeight() / 2 : Math.min(subImage.getHeight(), Math.max(0, yOffset)));
            targetElement = remote.getSubNodeFromLocation(imageElement, imageRelativeClickPointX, imageRelativeClickPointY, operationId, this.getRemainingTime());
            Rectangle targetBounds = remote.getNodeWindowRelativeBounds(targetElement, operationId);
            int targetRelativeClickPointX = imageRelativeClickPointX - (targetBounds.x - imageBounds.x);
            int targetRelativeClickPointY = imageRelativeClickPointY - (targetBounds.y - imageBounds.y);
            session.getRemote().click(targetElement, null, clickType, shift, alt, ctrl, targetRelativeClickPointX, targetRelativeClickPointY, operationId, this.getRemainingTime());
        }
        catch (Throwable throwable) {
            try {
                remote.freeNodeReference(imageElement);
                remote.freeNodeReference(targetElement);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            remote.freeNodeReference(imageElement);
            remote.freeNodeReference(targetElement);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

