/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.executors;

import java.util.Map;
import java.util.regex.Pattern;
import org.ibboost.orqa.automation.java.ProxyRunner;
import org.ibboost.orqa.automation.java.ProxySession;
import org.ibboost.orqa.automation.java.ProxySessionManager;
import org.ibboost.orqa.core.StringUtils;
import org.ibboost.orqa.core.execution.ExecutionContext;
import org.ibboost.orqa.core.execution.IExecutor;

public class AttachExecutor
implements IExecutor {
    public Object execute(ExecutionContext context, Map<String, Object> arguments) throws Exception {
        String name = (String)arguments.get("name");
        Float timeout = (Float)arguments.get("timeout");
        String sessionName = (String)arguments.get("session");
        boolean useRegex = (Boolean)arguments.get("useRegex");
        String windowNamePattern = useRegex ? name : StringUtils.createWildcardRegex((String)name);
        Pattern.compile(windowNamePattern);
        long stopTime = System.currentTimeMillis() + (long)(timeout.floatValue() * 1000.0f);
        while (true) {
            try {
                ProxySession session = ProxySessionManager.INSTANCE.attachSession(sessionName, windowNamePattern);
                ProxySessionManager.INSTANCE.setLastSession(session);
                return session;
            }
            catch (Exception e) {
                long remainingTime = stopTime - System.currentTimeMillis();
                if (e instanceof ProxyRunner.JdkConfigurationException || remainingTime <= 0L) {
                    throw e;
                }
                Thread.sleep(Math.min(100L, remainingTime));
                continue;
            }
            break;
        }
    }
}

