/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java;

import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.UUID;
import org.ibboost.orqa.automation.IEventReceiver;
import org.ibboost.orqa.automation.events.AutomatableEvent;
import org.ibboost.orqa.automation.events.AutomatableEventSource;
import org.ibboost.orqa.automation.events.AutomatableKeyEvent;
import org.ibboost.orqa.automation.events.AutomatableMouseEvent;
import org.ibboost.orqa.automation.events.AutomatableProgressEvent;
import org.ibboost.orqa.automation.events.enums.AutomatableClick;
import org.ibboost.orqa.automation.events.enums.AutomatableKey;
import org.ibboost.orqa.automation.java.common.IAutomationProxy;
import org.ibboost.orqa.automation.java.common.IRemoteEventReceiver;
import org.ibboost.orqa.automation.java.common.ProxyNodeReference;
import org.ibboost.orqa.automation.java.common.RMILoopbackSocketFactory;

public class ProxyEventReceiver
extends UnicastRemoteObject
implements IRemoteEventReceiver {
    private static final RMILoopbackSocketFactory SOCKET_FACTORY = new RMILoopbackSocketFactory();
    private static final long serialVersionUID = 1L;
    private final UUID id = UUID.randomUUID();
    private final IEventReceiver localReceiver;
    private final IAutomationProxy proxy;

    public ProxyEventReceiver(IAutomationProxy proxy, IEventReceiver localReceiver) throws RemoteException {
        super(0, (RMIClientSocketFactory)SOCKET_FACTORY, (RMIServerSocketFactory)SOCKET_FACTORY);
        this.localReceiver = localReceiver;
        this.proxy = proxy;
    }

    public void newKeyEvent(long timestamp, ProxyNodeReference source, String sourceText, String preEventSourceText, String sourceXPath, boolean sourceValueIsSettable, AutomatableKey key, boolean ctrlDown, boolean altDown, boolean shiftDown, boolean isPasswordField, String preEventXmlSnapshot, String xmlSnapshot) throws RemoteException {
        ProxyEventSource nodeRef = new ProxyEventSource(source);
        AutomatableKeyEvent event = new AutomatableKeyEvent(timestamp, (AutomatableEventSource)nodeRef, sourceText, preEventSourceText, sourceXPath, sourceValueIsSettable, false, key, ctrlDown, altDown, shiftDown, isPasswordField, null, preEventXmlSnapshot, xmlSnapshot);
        this.localReceiver.newEvent((AutomatableEvent)event);
    }

    public void newMouseEvent(long timestamp, ProxyNodeReference source, String sourceText, String preEventSourceText, String sourceXPath, boolean sourceValueIsSettable, AutomatableClick clickType, Integer x, Integer y, Boolean ctrlDown, Boolean altDown, Boolean shiftDown, boolean isPasswordField, String preEventXmlSnapshot, String xmlSnapshot) throws RemoteException {
        ProxyEventSource nodeRef = new ProxyEventSource(source);
        AutomatableMouseEvent event = new AutomatableMouseEvent(timestamp, (AutomatableEventSource)nodeRef, sourceText, preEventSourceText, sourceXPath, sourceValueIsSettable, false, clickType, x, y, ctrlDown, altDown, shiftDown, isPasswordField, null, preEventXmlSnapshot, xmlSnapshot);
        this.localReceiver.newEvent((AutomatableEvent)event);
    }

    public void newProgressEvent(long timestamp, String inProgressXPath, Integer duration, String preEventXmlSnapshot, String xmlSnapshot) {
        AutomatableProgressEvent event = new AutomatableProgressEvent(timestamp, inProgressXPath, duration, null, preEventXmlSnapshot, xmlSnapshot);
        this.localReceiver.newEvent((AutomatableEvent)event);
    }

    public UUID getId() throws RemoteException {
        return this.id;
    }

    private class ProxyEventSource
    implements AutomatableEventSource {
        private final ProxyNodeReference proxyNode;

        public ProxyEventSource(ProxyNodeReference proxyNode) {
            this.proxyNode = proxyNode;
        }

        public boolean equals(AutomatableEventSource other) {
            ProxyNodeReference otherNodeRef;
            block5: {
                block4: {
                    try {
                        if (other instanceof ProxyEventSource) break block4;
                        return false;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                otherNodeRef = ((ProxyEventSource)other).proxyNode;
                if (this.proxyNode.getSessionName().equals(otherNodeRef.getSessionName())) break block5;
                return false;
            }
            return ProxyEventReceiver.this.proxy.isSameNode(this.proxyNode, otherNodeRef);
        }

        public void dispose() {
            try {
                ProxyEventReceiver.this.proxy.freeNodeReference(this.proxyNode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

