/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java;

import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.RMILoopbackSocketFactory;
import org.ibboost.orqa.automation.java.common.logging.ILogCallback;
import org.ibboost.orqa.core.Logger;

public class LogCallBack
extends UnicastRemoteObject
implements ILogCallback {
    private static final Logger LOG = Logger.getLogger(LogCallBack.class);
    private static final long serialVersionUID = 1L;
    private static final RMILoopbackSocketFactory SOCKET_FACTORY = new RMILoopbackSocketFactory();

    public LogCallBack() throws RemoteException {
        super(0, (RMIClientSocketFactory)SOCKET_FACTORY, (RMIServerSocketFactory)SOCKET_FACTORY);
    }

    private static void log(Logger.Level level, JavaAppException e) {
        Object logEntry = e.getLocalizedMessage();
        if (e.getStackTraceAsString() != null && !e.getStackTraceAsString().isEmpty()) {
            logEntry = (String)logEntry + "\r\nRemote Application Stack:\r\n" + e.getStackTraceAsString();
        }
        LOG.log(level, (String)logEntry);
    }

    public void error(JavaAppException e) throws RemoteException {
        LogCallBack.log(Logger.Level.ERROR, e);
    }

    public void error(String message) throws RemoteException {
        LOG.error(message);
    }

    public void warning(JavaAppException e) throws RemoteException {
        LogCallBack.log(Logger.Level.WARN, e);
    }

    public void warning(String message) throws RemoteException {
        LOG.warn(message);
    }

    public void info(JavaAppException e) throws RemoteException {
        LogCallBack.log(Logger.Level.INFO, e);
    }

    public void info(String message) throws RemoteException {
        LOG.info(message);
    }

    public void debug(JavaAppException e) throws RemoteException {
        LogCallBack.log(Logger.Level.DEBUG, e);
    }

    public void debug(String message) throws RemoteException {
        LOG.debug(message);
    }
}

