/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java;

import java.util.HashMap;
import java.util.LinkedHashMap;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.ibboost.orqa.automation.java.ProxyRunner;
import org.ibboost.orqa.automation.java.common.JvmTools;
import org.ibboost.orqa.core.execution.preferences.ModelPreferenceTools;

public class JavaAutomationPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREFERENCE_STORE_ID = "org.ibboost.orqa.automation.java";
    public static final String JDK_PATH_32 = "java.jdk.path.32";
    public static final String JDK_PATH_64 = "java.jdk.path.64";
    public static final String SUPPRESS_GLASS_PANE = "java.glasspane.suppress";

    public static synchronized IPersistentPreferenceStore getStore() {
        boolean storeInitialised = ModelPreferenceTools.isStoreInitialised((String)PREFERENCE_STORE_ID);
        IPersistentPreferenceStore store = (IPersistentPreferenceStore)ModelPreferenceTools.getModelPreferenceStore((String)PREFERENCE_STORE_ID);
        if (!storeInitialised) {
            store.setDefault(SUPPRESS_GLASS_PANE, true);
        }
        return store;
    }

    public static boolean isJdkConfigured() {
        return !JavaAutomationPreferences.safeGetJdks().isEmpty();
    }

    public static HashMap<Integer, String> getJdks() throws Exception {
        HashMap<Integer, String> jdks = JavaAutomationPreferences.safeGetJdks();
        if (jdks.size() == 0) {
            throw new ProxyRunner.JdkConfigurationException("No JDK found. Specify a path to a JDK in the Java Automation preferences.");
        }
        return jdks;
    }

    private static HashMap<Integer, String> safeGetJdks() {
        String jdk32Pref;
        IPersistentPreferenceStore preferences;
        String jdk64Pref;
        String jdk32 = null;
        String jdk64 = null;
        String runningJvm = System.getProperties().getProperty("java.home");
        if (JvmTools.isJdk((String)runningJvm)) {
            String architecture = System.getProperty("sun.arch.data.model");
            if (architecture.contains("32")) {
                jdk32 = runningJvm;
            } else if (architecture.contains("64")) {
                jdk64 = runningJvm;
            }
        }
        if (!(jdk64Pref = (preferences = JavaAutomationPreferences.getStore()).getString(JDK_PATH_64)).trim().isEmpty()) {
            jdk64 = jdk64Pref;
        }
        if (!(jdk32Pref = preferences.getString(JDK_PATH_32)).trim().isEmpty()) {
            jdk32 = jdk32Pref;
        }
        LinkedHashMap<Integer, String> jdks = new LinkedHashMap<Integer, String>();
        if (jdk32 != null) {
            jdks.put(32, jdk32);
        }
        if (jdk64 != null) {
            jdks.put(64, jdk64);
        }
        return jdks;
    }

    public static int openPreferencesDialog() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        String pageId = JavaAutomationPreferences.class.getName();
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)pageId, null, null);
        return dialog.open();
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)JavaAutomationPreferences.getStore());
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.addField((FieldEditor)new DirectoryFieldEditor(JDK_PATH_32, "&32-Bit JDK Path:", parent));
        this.addField((FieldEditor)new DirectoryFieldEditor(JDK_PATH_64, "&64-Bit JDK Path:", parent));
        Composite comboComposite = new Composite(parent, 0);
        comboComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.addField((FieldEditor)new BooleanFieldEditor(SUPPRESS_GLASS_PANE, "Suppress app &glasspanes during picking and recording", comboComposite));
    }
}

