/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.xpath;

import org.ibboost.orqa.xpath.XPathLeafNode;
import org.ibboost.orqa.xpath.XPathParentNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XPathText
extends XPathLeafNode
implements Text {
    private static final String NO_MODIFICATION_ERROR = "No modification allowed";
    private final XPathParentNode parent;
    private String characterData;

    public XPathText(XPathParentNode parent) {
        this.parent = parent;
    }

    @Override
    public String getNodeName() {
        return "#text";
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getCharacterData();
    }

    @Override
    public short getNodeType() {
        return 3;
    }

    @Override
    public Node getParentNode() {
        return this.parent;
    }

    @Override
    public Document getOwnerDocument() {
        return this.parent.getOwnerDocument();
    }

    public String toString() {
        return String.valueOf(this.getParentNode().toString()) + "/" + this.getNodeName();
    }

    private String getCharacterData() {
        if (this.characterData == null) {
            this.characterData = this.initCharacterData();
        }
        return this.characterData;
    }

    protected abstract String initCharacterData();

    @Override
    public Text splitText(int offset) throws DOMException {
        throw new DOMException(7, NO_MODIFICATION_ERROR);
    }

    @Override
    public boolean isElementContentWhitespace() {
        return false;
    }

    @Override
    public String getWholeText() {
        return this.getCharacterData();
    }

    @Override
    public Text replaceWholeText(String content) throws DOMException {
        throw new DOMException(7, NO_MODIFICATION_ERROR);
    }

    @Override
    public String getData() throws DOMException {
        return this.getCharacterData();
    }

    @Override
    public void setData(String data) throws DOMException {
        throw new DOMException(7, NO_MODIFICATION_ERROR);
    }

    @Override
    public int getLength() {
        return this.getCharacterData().length();
    }

    @Override
    public String substringData(int offset, int count) throws DOMException {
        try {
            return this.getCharacterData().substring(offset, offset + count);
        }
        catch (Exception e) {
            throw new DOMException(1, e.getLocalizedMessage());
        }
    }

    @Override
    public void appendData(String arg) throws DOMException {
        throw new DOMException(7, NO_MODIFICATION_ERROR);
    }

    @Override
    public void insertData(int offset, String arg) throws DOMException {
        throw new DOMException(7, NO_MODIFICATION_ERROR);
    }

    @Override
    public void deleteData(int offset, int count) throws DOMException {
        throw new DOMException(7, NO_MODIFICATION_ERROR);
    }

    @Override
    public void replaceData(int offset, int count, String arg) throws DOMException {
        throw new DOMException(7, NO_MODIFICATION_ERROR);
    }
}

