/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.xpath;

import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.XPath2Expression;
import info.fingo.xactus.processor.Engine;
import info.fingo.xactus.processor.util.StaticContextBuilder;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.ibboost.orqa.xpath.XPath2Evaluator;
import org.ibboost.orqa.xpath.XPathNamespaceContext;
import org.ibboost.orqa.xpath.XPathNodeList;
import org.w3c.dom.Node;

public class XPathExpression {
    private static final Pattern INT_PATTERN = Pattern.compile("\\d+");
    private static final XPathFactory FACTORY = XPathFactory.newInstance();
    public static final int XPATH_V1 = 1;
    public static final int XPATH_V2 = 2;
    public static final int XPATH_ALL_VERSIONS = 3;
    public static final String PREFERRED_XPATH_VERSION_PROPERTY = "xpathVersion";
    private static final int XOBJECT_TYPE_NULL = -1;
    private static final int XOBJECT_TYPE_BOOLEAN = 1;
    private static final int XOBJECT_TYPE_NUMBER = 2;
    private static final int XOBJECT_TYPE_STRING = 3;
    private static final int XOBJECT_TYPE_NODESET = 4;
    private static final int XOBJECT_TYPE_TREEFRAG = 5;
    private static Integer xpathVersionOverride = null;
    private final String xpath;
    private final Boolean caseSensitive;
    private javax.xml.xpath.XPathExpression xpath1Expression;
    private XPath2Expression xpath2Expression;
    private StaticContextBuilder xpath2Context;
    private static boolean xpathV1EvaluateMethodsInitialised = false;
    private static Method evaluateExpressionMethod;
    private static Method getEvaluationResultValueMethod;
    private static Method evalMethod;
    private static Method xobjectTypeMethod;
    private static Method xobjectStrMethod;
    private static Method xobjectNumMethod;
    private static Method xobjectBoolMethod;
    private static Method xobjectNodeListMethod;

    public XPathExpression(String xpath) throws XPathExpressionException {
        this(xpath, null);
    }

    public XPathExpression(String xpath, Map<String, String> namespaceMappings) throws XPathExpressionException {
        this(xpath, null, namespaceMappings, true);
    }

    public XPathExpression(String xpath, Integer xpathVersions, Map<String, String> namespaceMappings, boolean caseSensitive) throws XPathExpressionException {
        Exception exception;
        boolean matchesSupportedVersion;
        block14: {
            this.xpath = xpath;
            this.caseSensitive = caseSensitive;
            if (xpathVersions == null) {
                xpathVersions = XPathExpression.getPreferredXPathVersion();
            }
            if (xpathVersions == null) {
                xpathVersions = 3;
            }
            matchesSupportedVersion = false;
            exception = null;
            try {
                if ((xpathVersions & 1) != 0) {
                    matchesSupportedVersion = true;
                    if (!caseSensitive) {
                        throw new XPathExpressionException("Case insensitive paths not supported for XPath 1");
                    }
                    XPath factory = FACTORY.newXPath();
                    if (namespaceMappings != null && !namespaceMappings.isEmpty()) {
                        factory.setNamespaceContext(new XPathNamespaceContext(namespaceMappings));
                    }
                    this.xpath1Expression = factory.compile(xpath);
                }
            }
            catch (Exception e) {
                exception = e;
            }
            try {
                if ((xpathVersions & 2) != 0) {
                    matchesSupportedVersion = true;
                    this.xpath2Context = new StaticContextBuilder();
                    if (namespaceMappings != null) {
                        for (Map.Entry<String, String> mapping : namespaceMappings.entrySet()) {
                            this.xpath2Context.withNamespace(mapping.getKey(), mapping.getValue());
                        }
                    }
                    this.xpath2Expression = new Engine().parseExpression(xpath, this.xpath2Context);
                }
            }
            catch (Exception e) {
                if (exception != null) break block14;
                exception = e;
            }
        }
        if (!matchesSupportedVersion) {
            throw new UnsupportedXPathVersionException(xpathVersions);
        }
        if (this.xpath1Expression == null && this.xpath2Expression == null) {
            throw this.toXPathExpressionException(exception);
        }
    }

    public static void setPreferredXPathVerion(Integer xpathVersionOverride) {
        XPathExpression.xpathVersionOverride = xpathVersionOverride;
    }

    public static Integer getPreferredXPathVersion() {
        if (xpathVersionOverride != null) {
            return xpathVersionOverride;
        }
        String preferredXPathVersion = System.getProperty(PREFERRED_XPATH_VERSION_PROPERTY);
        if (preferredXPathVersion == null) {
            return null;
        }
        if (preferredXPathVersion.equals("1")) {
            return 1;
        }
        if (preferredXPathVersion.equals("2")) {
            return 2;
        }
        return null;
    }

    private XPathExpressionException toXPathExpressionException(Throwable e) {
        if (e instanceof XPathExpressionException) {
            return (XPathExpressionException)e;
        }
        String message = e.getMessage();
        while (e.getCause() != null && e.getCause() != e) {
            if ((e = e.getCause()).getMessage() == null || e.getMessage().isEmpty()) continue;
            message = e.getMessage();
        }
        return new XPathExpressionException(String.format("'%s' - %s", this.xpath, message));
    }

    public Object evaluate(Node root, QName returnType) throws XPathExpressionException {
        try {
            block7: {
                try {
                    if (this.xpath1Expression != null) {
                        Object queryResult = XPathExpression.xpathV1Evaluate(this.xpath1Expression, root, returnType);
                        return XPathExpression.coerceQueryResult(queryResult, returnType);
                    }
                }
                catch (XPathExpressionException e) {
                    if (this.xpath2Expression != null) break block7;
                    throw e;
                }
            }
            if (this.xpath2Expression != null) {
                ResultSequence resultSequence = new XPath2Evaluator(this.xpath2Context, root, this.caseSensitive).evaluate2((info.fingo.xactus.processor.ast.XPath)this.xpath2Expression);
                ArrayList<Object> resultItems = new ArrayList<Object>();
                for (Item result : resultSequence) {
                    resultItems.add(result.getNativeValue());
                }
                return XPathExpression.coerceQueryResult(resultItems, returnType);
            }
        }
        catch (Exception e) {
            throw this.toXPathExpressionException(e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object xpathV1Evaluate(javax.xml.xpath.XPathExpression expression, Node root, QName returnType) throws XPathExpressionException {
        if (returnType != null) {
            return expression.evaluate(root, returnType);
        }
        XPathExpression.initXPathV1EvaluateMethods(expression);
        try {
            if (evaluateExpressionMethod != null) {
                Object evaluationResult = evaluateExpressionMethod.invoke((Object)expression, root);
                return getEvaluationResultValueMethod.invoke(evaluationResult, new Object[0]);
            }
            if (evalMethod != null) {
                Object evalResult = evalMethod.invoke((Object)expression, root);
                int resultType = (Integer)xobjectTypeMethod.invoke(evalResult, new Object[0]);
                switch (resultType) {
                    case -1: {
                        return null;
                    }
                    case 1: {
                        return xobjectBoolMethod.invoke(evalResult, new Object[0]);
                    }
                    case 2: {
                        return xobjectNumMethod.invoke(evalResult, new Object[0]);
                    }
                    case 3: {
                        return xobjectStrMethod.invoke(evalResult, new Object[0]);
                    }
                    case 4: 
                    case 5: {
                        return xobjectNodeListMethod.invoke(evalResult, new Object[0]);
                    }
                }
                throw new Exception(String.format("Unsupported result type: %s", evalResult.getClass()));
            }
        }
        catch (Exception e) {
            throw new XPathExpressionException(e);
        }
        try {
            return expression.evaluate(root, XPathConstants.NODESET);
        }
        catch (Exception exception) {
            return expression.evaluate(root, XPathConstants.STRING);
        }
    }

    public static Object coerceQueryResult(Object o, QName returnType) {
        XPathNodeList nodeList = XPathNodeList.fromNodes(o);
        if (returnType == XPathConstants.NODESET) {
            if (nodeList != null) {
                return nodeList;
            }
            if (o == null) {
                return new XPathNodeList();
            }
            XPathNodeList.assertNodeSet(o);
        }
        if (returnType == null && nodeList != null) {
            return nodeList;
        }
        if (o instanceof Iterable) {
            Iterator iterator = ((Iterable)o).iterator();
            Object object = o = iterator.hasNext() ? (Object)iterator.next() : null;
        }
        if (o == null) {
            if (returnType == null) {
                return new XPathNodeList();
            }
            return o;
        }
        if (returnType == XPathConstants.NODE) {
            return Node.class.cast(o);
        }
        String sVal = null;
        if (o instanceof Node) {
            String textContent;
            sVal = ((Node)o).getNodeValue();
            if ((sVal == null || sVal.isEmpty()) && (textContent = ((Node)o).getTextContent()) != null) {
                sVal = textContent;
            }
            if (sVal == null) {
                sVal = "";
            }
        } else {
            sVal = o.toString();
        }
        if (returnType == XPathConstants.STRING) {
            return sVal;
        }
        if (returnType == XPathConstants.NUMBER) {
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            if (INT_PATTERN.matcher(sVal).matches()) {
                return Long.valueOf(sVal).doubleValue();
            }
            return new BigDecimal(sVal).doubleValue();
        }
        if (returnType == XPathConstants.BOOLEAN) {
            if (o instanceof Boolean) {
                return o;
            }
            if (o instanceof Integer || o instanceof Short || o instanceof Long) {
                if (((Number)o).intValue() != 0) {
                    return true;
                }
                return false;
            }
            if (o instanceof Number) {
                if (((Number)o).doubleValue() != 0.0) {
                    return true;
                }
                return false;
            }
            return !sVal.equalsIgnoreCase("false") && !sVal.equals("0") && !sVal.equals("");
        }
        return o;
    }

    private static synchronized void initXPathV1EvaluateMethods(javax.xml.xpath.XPathExpression expression) {
        if (xpathV1EvaluateMethodsInitialised) {
            return;
        }
        xpathV1EvaluateMethodsInitialised = true;
        try {
            evaluateExpressionMethod = javax.xml.xpath.XPathExpression.class.getDeclaredMethod("evaluateExpression", Object.class);
            getEvaluationResultValueMethod = evaluateExpressionMethod.getReturnType().getDeclaredMethod("value", new Class[0]);
            return;
        }
        catch (Throwable throwable) {
            evaluateExpressionMethod = null;
            try {
                Class<?> expressionClass = expression.getClass();
                while (expressionClass != null) {
                    try {
                        evalMethod = expressionClass.getDeclaredMethod("eval", Object.class);
                        evalMethod.setAccessible(true);
                        Class<?> xObjectClass = evalMethod.getReturnType();
                        xobjectTypeMethod = xObjectClass.getDeclaredMethod("getType", new Class[0]);
                        xobjectStrMethod = xObjectClass.getDeclaredMethod("str", new Class[0]);
                        xobjectNumMethod = xObjectClass.getDeclaredMethod("num", new Class[0]);
                        xobjectBoolMethod = xObjectClass.getDeclaredMethod("bool", new Class[0]);
                        xobjectNodeListMethod = xObjectClass.getDeclaredMethod("nodelist", new Class[0]);
                    }
                    catch (Throwable throwable2) {
                        evalMethod = null;
                        expressionClass = expressionClass.getSuperclass();
                    }
                }
            }
            catch (Throwable throwable3) {
                evalMethod = null;
            }
        }
    }

    public static class UnsupportedXPathVersionException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public UnsupportedXPathVersionException(int version2) {
            super(String.format("Unsupported xpath version %d", version2));
        }
    }
}

