/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.xpath;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathBuilder {
    private final Map<Node, String> pathCache = new HashMap<Node, String>();
    private final Map<Node, String> fullPathCache = new HashMap<Node, String>();
    private final Map<Node, Integer> descendentNodeFilters = new HashMap<Node, Integer>();
    private final Map<String, Integer> descendentNameFilters = new HashMap<String, Integer>();
    private Node rootNode;
    private Set<String> textElementNames = Collections.emptySet();
    private String[] attributeNames = new String[]{"id"};

    public void setRootNode(Node rootNode) {
        this.rootNode = rootNode;
    }

    public void setAllowedElementDescendents(String elementName, String[] descendentElementNames) {
        int descendentFilter = 0;
        String[] stringArray = descendentElementNames;
        int n = descendentElementNames.length;
        int n2 = 0;
        while (n2 < n) {
            String descendentElementName = stringArray[n2];
            descendentFilter |= descendentElementName.hashCode();
            ++n2;
        }
        this.descendentNameFilters.put(elementName, descendentFilter);
    }

    public void setPreferredTextElements(String[] elementNames) {
        this.textElementNames = new HashSet<String>(Arrays.asList(elementNames));
    }

    public void setPreferredAttributes(String[] attributeNames) {
        this.attributeNames = attributeNames;
    }

    public String getPathToNode(Node node, boolean optimize) {
        if (node instanceof Document) {
            return "/";
        }
        if (node instanceof Element) {
            if (optimize) {
                return this.internalPathToNode(node, true);
            }
            return this.fullPathToNode(node, true);
        }
        throw new IllegalArgumentException();
    }

    private String fullPathToNode(Node node, boolean forceAttributeMatch) {
        if (node instanceof Document) {
            return "";
        }
        if (node.equals(this.rootNode)) {
            return ".";
        }
        if (!forceAttributeMatch && this.fullPathCache.containsKey(node)) {
            return this.fullPathCache.get(node);
        }
        Node parent = node.getParentNode();
        String path = String.valueOf(this.fullPathToNode(parent, false)) + "/" + this.getElementReference((Element)node, parent.getChildNodes(), forceAttributeMatch);
        if (!forceAttributeMatch) {
            this.fullPathCache.put(node, path);
        }
        return path;
    }

    private String internalPathToNode(Node node, boolean forceAttributeMatch) {
        if (node instanceof Document) {
            return "";
        }
        if (node.equals(this.rootNode)) {
            return ".";
        }
        if (!forceAttributeMatch && this.pathCache.containsKey(node)) {
            return this.pathCache.get(node);
        }
        Element element = (Element)node;
        String elementName = element.getTagName();
        int elementNameHash = elementName.hashCode();
        Node parent = element.getParentNode();
        String bestAncestorPath = String.valueOf(this.internalPathToNode(parent, false)) + "/";
        Node possibleAncestor = this.getParent(parent);
        while (possibleAncestor != null && !this.isDescendentElement(elementName, elementNameHash, possibleAncestor, parent)) {
            String possibleAncestorPath = String.valueOf(this.internalPathToNode(possibleAncestor, false)) + "//";
            if (possibleAncestorPath.length() < bestAncestorPath.length()) {
                bestAncestorPath = possibleAncestorPath;
            }
            possibleAncestor = this.getParent(possibleAncestor);
        }
        String path = String.valueOf(bestAncestorPath) + this.getElementReference(element, parent.getChildNodes(), forceAttributeMatch);
        if (!forceAttributeMatch) {
            this.pathCache.put(node, path);
        }
        return path;
    }

    private Node getParent(Node node) {
        if (node.equals(this.rootNode)) {
            return null;
        }
        return node.getParentNode();
    }

    private String getElementReference(Element element, NodeList siblings, boolean forceAttributeMatch) {
        String tagName = element.getTagName();
        String textValue = this.textElementNames.contains(tagName) ? XPathBuilder.getElementText(element) : null;
        String[] attributeValues = new String[this.attributeNames.length];
        boolean[] attributeIsUnique = new boolean[this.attributeNames.length];
        int aindex = 0;
        while (aindex < this.attributeNames.length) {
            attributeValues[aindex] = element.getAttribute(this.attributeNames[aindex]);
            attributeIsUnique[aindex] = !attributeValues[aindex].isEmpty();
            ++aindex;
        }
        int tagCount = 0;
        int position = 0;
        int i = 0;
        while (i < siblings.getLength()) {
            Element sibling;
            if (siblings.item(i) instanceof Element && (sibling = (Element)siblings.item(i)).getTagName().equals(tagName)) {
                ++tagCount;
                if (sibling.equals(element)) {
                    position = tagCount;
                } else {
                    int aindex2 = 0;
                    while (aindex2 < this.attributeNames.length) {
                        if (attributeIsUnique[aindex2]) {
                            String attributeValue = sibling.getAttribute(this.attributeNames[aindex2]);
                            attributeIsUnique[aindex2] = !attributeValues[aindex2].equals(attributeValue);
                        }
                        ++aindex2;
                    }
                    if (textValue != null && textValue.equals(XPathBuilder.getElementText(sibling))) {
                        textValue = null;
                    }
                }
            }
            ++i;
        }
        if (tagCount > 1 || forceAttributeMatch) {
            int aindex3 = 0;
            while (aindex3 < this.attributeNames.length) {
                if (attributeIsUnique[aindex3]) {
                    String attributeName = this.attributeNames[aindex3];
                    String attributeValue = attributeValues[aindex3].replace("\"", "&quot;");
                    return String.format("%s[@%s=\"%s\"]", tagName, attributeName, attributeValue);
                }
                ++aindex3;
            }
            if (textValue != null) {
                textValue = textValue.replace("\"", "&quot;");
                return String.format("%s[text()=\"%s\"]", tagName, textValue);
            }
        }
        if (tagCount == 1) {
            return tagName;
        }
        return String.format("%s[%d]", tagName, position);
    }

    private static String getElementText(Element element) {
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3) {
                return child.getNodeValue();
            }
            child = child.getNextSibling();
        }
        return null;
    }

    private boolean isDescendentElement(String elementName, int elementNameHash, Node parent, Node ignoredParent) {
        if (!parent.hasChildNodes()) {
            return false;
        }
        if ((this.getDescendentNameFilter(parent) & elementNameHash) != elementNameHash) {
            return false;
        }
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (!parent.equals(ignoredParent) && child.getNodeName().equals(elementName)) {
                return true;
            }
            if (this.isDescendentElement(elementName, elementNameHash, child, ignoredParent)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int getDescendentNameFilter(Node parent) {
        Integer cachedFilter = this.descendentNodeFilters.get(parent);
        if (cachedFilter != null) {
            return cachedFilter;
        }
        cachedFilter = this.descendentNameFilters.get(parent.getNodeName());
        if (cachedFilter != null) {
            return cachedFilter;
        }
        int filter = 0;
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                filter |= child.getNodeName().hashCode();
                if (child.hasChildNodes()) {
                    filter |= this.getDescendentNameFilter(child);
                }
            }
            ++i;
        }
        this.descendentNodeFilters.put(parent, filter);
        return filter;
    }
}

