/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.xpath;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.StaticContext;
import info.fingo.xactus.processor.DefaultEvaluator;
import info.fingo.xactus.processor.internal.ast.NameTest;
import info.fingo.xactus.processor.internal.types.NodeType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.util.DynamicContextBuilder;
import info.fingo.xactus.processor.util.StaticContextBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.w3c.dom.Node;

public class XPath2Evaluator
extends DefaultEvaluator {
    private static Field PARAM;
    private static Field P1;
    private static Field P2;
    private static Method NAME_TEST;
    private final boolean caseSensitive;

    public XPath2Evaluator(StaticContextBuilder staticContext, Node root) {
        this(staticContext, root, true);
    }

    public XPath2Evaluator(StaticContextBuilder staticContext, Node root, boolean caseSensitive) {
        super((StaticContext)staticContext, (DynamicContext)new DynamicContextBuilder(staticContext), new Object[]{root});
        this.caseSensitive = caseSensitive;
    }

    private static void initFields(XPath2Evaluator evaluator) throws Exception {
        if (PARAM != null) {
            return;
        }
        PARAM = DefaultEvaluator.class.getDeclaredField("_param");
        PARAM.setAccessible(true);
        Object _param = PARAM.get(evaluator);
        P1 = _param.getClass().getDeclaredField("_one");
        P1.setAccessible(true);
        P2 = _param.getClass().getDeclaredField("_two");
        P2.setAccessible(true);
        NAME_TEST = DefaultEvaluator.class.getDeclaredMethod("name_test", NodeType.class, QName.class, String.class);
        NAME_TEST.setAccessible(true);
    }

    @Override
    public ResultSequence visit(NameTest nameTest) {
        if (this.caseSensitive) {
            return super.visit(nameTest);
        }
        try {
            XPath2Evaluator.initFields(this);
            Object param = PARAM.get(this);
            ResultBuffer matches = new ResultBuffer();
            String type = (String)P1.get(param);
            for (NodeType node : (ResultSequence)P2.get(param)) {
                if (node == null || node.node_name() == null) continue;
                QName name = nameTest.name();
                if (!this.caseSensitive && !node.node_name().local().equals(name.local()) && node.node_name().local().equalsIgnoreCase(name.local())) {
                    name = this.changeLocalName(name, node.node_name().local());
                }
                if (!((Boolean)NAME_TEST.invoke((Object)this, node, name, type)).booleanValue()) continue;
                matches.add(node);
            }
            ResultSequence result = matches.getSequence();
            P2.set(param, result);
            return result;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private QName changeLocalName(QName name, String newLocalName) {
        if (name.expanded()) {
            return new QName(name.prefix(), newLocalName, name.namespace());
        }
        return new QName(name.prefix(), newLocalName);
    }
}

