/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.xpath;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.ibboost.orqa.xpath.XPathExpression;
import org.ibboost.orqa.xpath.XPathWaitType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPath {
    public static Node queryNode(Node root, String target) {
        return (Node)XPath.evaluate(root, target, XPathConstants.NODE);
    }

    public static Node queryNode(Node root, String target, long timeout) throws InterruptedException {
        return (Node)XPath.evaluate(root, target, XPathConstants.NODE, timeout);
    }

    public static NodeList queryNodeSet(Node root, String target) {
        return (NodeList)XPath.evaluate(root, target, XPathConstants.NODESET);
    }

    public static NodeList queryNodeSet(Node root, String target, long timeout) throws InterruptedException {
        return (NodeList)XPath.evaluate(root, target, XPathConstants.NODESET, timeout);
    }

    public static Object evaluate(Node root, String target) {
        return XPath.evaluate(root, target, null);
    }

    public static Object evaluate(Node root, String target, long timeout) throws InterruptedException {
        return XPath.evaluate(root, target, null, timeout);
    }

    public static Object evaluate(Node root, String target, QName type, long timeout) throws InterruptedException {
        long stopTime = System.currentTimeMillis() + timeout;
        while (true) {
            Object result = XPath.evaluate(root, target, type);
            long remainingTime = stopTime - System.currentTimeMillis();
            if (result instanceof NodeList ? ((NodeList)result).getLength() > 0 : result != null) {
                return result;
            }
            if (remainingTime <= 0L) {
                return result;
            }
            Thread.sleep(Math.min(100L, remainingTime));
            root.normalize();
        }
    }

    public static Object evaluate(Node root, String target, QName type) {
        try {
            return new XPathExpression(target).evaluate(root, type);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void waitForNode(Node root, String target, XPathWaitType waitType, String targetValue, long timeout) throws InterruptedException, TimeoutException {
        XPath.waitForNode(root, target, waitType, targetValue, timeout, null);
    }

    public static void waitForNode(Node root, String target, XPathWaitType waitType, String targetValue, long timeout, Callable<Node> nodeFinder) throws InterruptedException, TimeoutException {
        if (targetValue == null && waitType != XPathWaitType.NOT_EXIST && waitType != XPathWaitType.EXIST) {
            throw new UnsupportedOperationException(String.format("Condition can't be null for '%s' operation", new Object[]{waitType}));
        }
        long stopTime = System.currentTimeMillis() + timeout;
        while (true) {
            Node result;
            try {
                result = nodeFinder == null ? XPath.queryNode(root, target) : nodeFinder.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            long remainingTime = stopTime - System.currentTimeMillis();
            if (waitType == XPathWaitType.NOT_EXIST && result == null) {
                return;
            }
            if (waitType == XPathWaitType.EXIST) {
                if (result != null) {
                    return;
                }
            } else if (result != null) {
                NodeList children = result.getChildNodes();
                String text = null;
                int i = 0;
                while (i < children.getLength()) {
                    if (children.item(i).getNodeType() == 3) {
                        text = children.item(i).getNodeValue();
                        break;
                    }
                    ++i;
                }
                if (text != null) {
                    if (waitType == XPathWaitType.CONTAINS && text.contains(targetValue)) {
                        return;
                    }
                    if (waitType == XPathWaitType.STARTS_WITH && text.startsWith(targetValue)) {
                        return;
                    }
                    if (waitType == XPathWaitType.ENDS_WITH && text.endsWith(targetValue)) {
                        return;
                    }
                    if (waitType == XPathWaitType.EQUAL && text.equals(targetValue)) {
                        return;
                    }
                    if (waitType == XPathWaitType.NOT_EQUAL && !text.equals(targetValue)) {
                        return;
                    }
                }
            }
            if (remainingTime <= 0L) {
                String action = "";
                if (waitType == XPathWaitType.EXIST) {
                    action = "appear";
                }
                if (waitType == XPathWaitType.NOT_EXIST) {
                    action = "disappear";
                }
                if (waitType == XPathWaitType.CONTAINS) {
                    action = "contain '%s'";
                }
                if (waitType == XPathWaitType.STARTS_WITH) {
                    action = "start with '%s'";
                }
                if (waitType == XPathWaitType.ENDS_WITH) {
                    action = "end with '%s'";
                }
                if (waitType == XPathWaitType.EQUAL) {
                    action = "be equal to '%s'";
                }
                if (waitType == XPathWaitType.NOT_EQUAL) {
                    action = "be not equal to '%s'";
                }
                action = String.format(action, targetValue);
                throw new TimeoutException(String.format("Timed out waiting for target '%s' to %s.", target, action));
            }
            Thread.sleep(Math.min(100L, remainingTime));
            root.normalize();
        }
    }
}

