/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.swt;

import java.awt.Point;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.ibboost.orqa.automation.events.enums.AutomatableClick;
import org.ibboost.orqa.automation.events.enums.AutomatableKey;
import org.ibboost.orqa.automation.java.common.IAutomationProxy;
import org.ibboost.orqa.automation.java.common.INodeCaptureReceiver;
import org.ibboost.orqa.automation.java.common.IRemoteEventReceiver;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.AutomationDocument;
import org.ibboost.orqa.automation.java.proxy.AutomationElement;
import org.ibboost.orqa.automation.java.proxy.AutomationTarget;
import org.ibboost.orqa.automation.java.proxy.NodeManager;
import org.ibboost.orqa.automation.java.proxy.UiThreadJobManager;
import org.ibboost.orqa.automation.java.proxy.automatable.Automatable;
import org.ibboost.orqa.automation.java.proxy.automatable.AutomationEventListener;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableComboBox;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableComboBoxEntry;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableSwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.Swt;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.SwtAutomatableKey;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.SwtEventHandler;
import org.w3c.dom.Node;

public class SwtEventCapture {
    private static final long EVENT_CALLBACK_TIMEOUT = 10000L;
    private static final List<Integer> NODE_RECEIVER_EVENTS = Arrays.asList(3, 4, 8, 13, 30, 2, 1);
    private static final List<Integer> EVENT_RECEIVER_EVENTS = Arrays.asList(3, 8, 13, 30, 1);
    private static final List<Integer> MOUSE_EVENTS = Arrays.asList(3, 4, 5, 6, 7, 8);
    private static final List<Integer> KEY_EVENTS = Arrays.asList(1, 2);
    private static final List<Integer> INPUT_BLOCKER_EVENTS = Arrays.asList(3, 4, 5, 6, 7, 8, 1, 2, 13);
    private static final AtomicReference<Object> inputBlocker = new AtomicReference();
    private static final ConcurrentHashMap<UUID, Object> nodeCaptureReceivers = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Object> eventReceivers = new ConcurrentHashMap();

    private static synchronized void addDisplayFilter(final Object listener, final List<Integer> events) throws JavaAppException {
        try {
            UiThreadJobManager.asyncRunOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object display = Swt.getDefaultDisplay();
                        Iterator iterator = events.iterator();
                        while (iterator.hasNext()) {
                            int eventType = (Integer)iterator.next();
                            Reflection.safeCall(display, "addFilter", Integer.TYPE, eventType, Swt.LISTENER_CLASS, listener);
                        }
                    }
                    catch (Exception e) {
                        RemoteLogger.error(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw JavaAppException.wrap(e);
        }
    }

    private static synchronized void removeDisplayFilter(final Object listener, final List<Integer> events) throws JavaAppException {
        try {
            UiThreadJobManager.asyncRunOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object display = Swt.getDefaultDisplay();
                        Iterator iterator = events.iterator();
                        while (iterator.hasNext()) {
                            int eventType = (Integer)iterator.next();
                            Reflection.safeCall(display, "removeFilter", Integer.TYPE, eventType, Swt.LISTENER_CLASS, listener);
                        }
                    }
                    catch (Exception e) {
                        RemoteLogger.error(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw JavaAppException.wrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void blockUserInput() throws RemoteException {
        AtomicReference<Object> atomicReference = inputBlocker;
        synchronized (atomicReference) {
            if (inputBlocker.get() != null) {
                return;
            }
            Object listener = Swt.createEventListener(new SwtEventHandler(){

                @Override
                public void handleEvent(Object event) {
                    if (Swt.INJECTED_EVENT_CLASS.isInstance(event)) {
                        return;
                    }
                    try {
                        Reflection.setPropertyWithReflection(event, "type", false, 0);
                    }
                    catch (Exception e) {
                        RemoteLogger.error(e);
                    }
                }
            });
            inputBlocker.set(listener);
            SwtEventCapture.addDisplayFilter(listener, INPUT_BLOCKER_EVENTS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unblockUserInput() throws RemoteException {
        AtomicReference<Object> atomicReference = inputBlocker;
        synchronized (atomicReference) {
            Object listener = inputBlocker.getAndSet(null);
            if (listener != null) {
                SwtEventCapture.removeDisplayFilter(listener, INPUT_BLOCKER_EVENTS);
            }
        }
    }

    public static void registerNodeCaptureReceiver(final INodeCaptureReceiver receiver, final boolean captureXPaths, final boolean optimizeCapturedXPaths) throws RemoteException {
        Object listener = Swt.createEventListener(new SwtEventHandler(){
            private int lastInputEventType = 0;
            private AutomationElement lastArmedMenuItem;
            private String lastArmedMenuItemXPath;

            private String getAutomationElementPath(AutomationElement element) throws RemoteException {
                return AutomationDocument.getNodeXPath(element, IAutomationProxy.PREFERRED_TEXT_ELEMENTS, IAutomationProxy.PREFERRED_ATTRIBUTES, optimizeCapturedXPaths);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(Object event) {
                if (Swt.INJECTED_EVENT_CLASS.isInstance(event)) {
                    return;
                }
                Object widget = Reflection.getPropertyWithReflection(event, "widget", false, null);
                int eventType = (Integer)Reflection.getPropertyWithReflection(event, "type", false, 0);
                int button = (Integer)Reflection.getPropertyWithReflection(event, "button", false, 0);
                int stateMask = (Integer)Reflection.getPropertyWithReflection(event, "stateMask", false, 0);
                int xOffset = (Integer)Reflection.getPropertyWithReflection(event, "x", false, 0);
                int yOffset = (Integer)Reflection.getPropertyWithReflection(event, "y", false, 0);
                boolean shiftDown = (stateMask & 0x20000) != 0;
                boolean ctrlDown = (stateMask & 0x40000) != 0;
                try {
                    if (eventType == 30) {
                        if (!Swt.MENU_ITEM_CLASS.isInstance(widget)) {
                            return;
                        }
                        this.lastArmedMenuItem = new AutomationDocument().findAutomatableElement(AutomatableSwtComponent.automatableFromComponent(widget));
                        String string = this.lastArmedMenuItemXPath = captureXPaths ? this.getAutomationElementPath(this.lastArmedMenuItem) : null;
                        if (captureXPaths) {
                            return;
                        }
                    }
                    if (eventType == 13 && !Swt.MENU_ITEM_CLASS.isInstance(widget) && !Swt.COMBO_CLASS.isInstance(widget)) {
                        if (MOUSE_EVENTS.contains(this.lastInputEventType)) {
                            Reflection.setPropertyWithReflection(event, "type", false, 0);
                        }
                        return;
                    }
                    if (KEY_EVENTS.contains(eventType) || MOUSE_EVENTS.contains(eventType) && button != 1) {
                        return;
                    }
                    if (ctrlDown) {
                        stateMask &= 0xFFFBFFFF;
                        if (eventType == 4) {
                            Reflection.safeCall(widget, "sendSelectionEvent", Integer.TYPE, 13);
                        }
                        return;
                    }
                    Reflection.setPropertyWithReflection(event, "type", false, 0);
                    if (eventType == 4 || eventType == 13 || eventType == 30) {
                        Point clickOffset;
                        Automatable eventTarget = AutomatableSwtComponent.automatableFromComponent(widget);
                        if (eventTarget instanceof AutomatableComboBox && eventType == 13) {
                            AutomatableComboBoxEntry comboBoxEntry;
                            Integer selectionIndex = (Integer)Reflection.safeCall(widget, "getSelectionIndex", new Object[0]);
                            AutomatableComboBoxEntry automatableComboBoxEntry = comboBoxEntry = selectionIndex != null ? ((AutomatableComboBox)eventTarget).getComboxBoxEntry(selectionIndex) : null;
                            if (comboBoxEntry != null) {
                                eventTarget = comboBoxEntry;
                            }
                            clickOffset = new Point(0, 0);
                        } else if (shiftDown) {
                            clickOffset = new Point(xOffset, yOffset);
                        } else {
                            AutomationTarget automationTarget = eventTarget.getClickEventTarget(new Point(xOffset, yOffset));
                            eventTarget = automationTarget.getAutomatable();
                            clickOffset = new Point(automationTarget.getX(), automationTarget.getY());
                        }
                        final AtomicReference<AutomationElement> element = new AtomicReference<AutomationElement>();
                        final AtomicReference<String> xPath = new AtomicReference<String>();
                        if (this.lastArmedMenuItem != null && eventTarget.equals(this.lastArmedMenuItem.getAutomatable())) {
                            element.set(this.lastArmedMenuItem);
                            xPath.set(this.lastArmedMenuItemXPath);
                        } else {
                            element.set(new AutomationDocument().findAutomatableElement(eventTarget));
                            if (captureXPaths) {
                                xPath.set(this.getAutomationElementPath((AutomationElement)element.get()));
                            }
                        }
                        UiThreadJobManager.pauseUiThreadForExternalJob(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    receiver.nodeCaptured(NodeManager.getNodeReference((Node)element.get()), (String)xPath.get(), clickOffset);
                                }
                                catch (Exception e) {
                                    RemoteLogger.error(e);
                                }
                            }
                        }, 10000L);
                    }
                }
                catch (Exception e) {
                    RemoteLogger.error(e);
                }
                finally {
                    this.lastInputEventType = eventType;
                }
            }
        });
        nodeCaptureReceivers.put(receiver.getId(), listener);
        SwtEventCapture.addDisplayFilter(listener, NODE_RECEIVER_EVENTS);
    }

    public static void unregisterNodeCaptureReceiver(INodeCaptureReceiver receiver) throws RemoteException {
        Object listener = nodeCaptureReceivers.remove(receiver.getId());
        if (listener != null) {
            SwtEventCapture.removeDisplayFilter(listener, NODE_RECEIVER_EVENTS);
        }
    }

    public static void registerEventRecever(IRemoteEventReceiver receiver, boolean optimizeXPaths, boolean captureXmlSnapshots) throws RemoteException {
        Object listener = Swt.createEventListener(new SwtAutomationEventListener(receiver, optimizeXPaths, captureXmlSnapshots));
        eventReceivers.put(receiver.getId(), listener);
        SwtEventCapture.addDisplayFilter(listener, EVENT_RECEIVER_EVENTS);
    }

    public static void unregisterEventReceiver(IRemoteEventReceiver receiver) throws RemoteException {
        Object listener = eventReceivers.remove(receiver.getId());
        if (listener != null) {
            SwtEventCapture.removeDisplayFilter(listener, EVENT_RECEIVER_EVENTS);
            ((SwtAutomationEventListener)Reflection.safeCall(listener, "getEventHandler", new Object[0])).dispose();
        }
    }

    private static class SwtAutomationEventListener
    extends AutomationEventListener
    implements SwtEventHandler {
        private LinkedList<MenuArmEventSnapshot> menuTrail = new LinkedList();

        public SwtAutomationEventListener(IRemoteEventReceiver receiver, boolean optimizeXPaths, boolean captureXmlSnapshots) {
            super(receiver, optimizeXPaths, captureXmlSnapshots);
        }

        private void menuItemArmed(Object menuItem, int x, int y, boolean ctrlDown, boolean altDown, boolean shiftDown) {
            Object parentMenu = Reflection.safeCall(menuItem, "getParent", new Object[0]);
            for (int i = 0; i < this.menuTrail.size(); ++i) {
                MenuArmEventSnapshot trailItem = this.menuTrail.get(i);
                if (!trailItem.parentMenu.equals(parentMenu)) continue;
                while (this.menuTrail.size() > i) {
                    this.menuTrail.remove(i);
                }
                break;
            }
            AutomatableSwtComponent automatable = AutomatableSwtComponent.automatableFromComponent(menuItem);
            AutomationTarget automationTarget = new AutomationTarget(automatable, x, y);
            AutomationElement element = new AutomationDocument().findAutomatableElement(automatable);
            String xPath = this.xPathFromAutomationElement(element);
            this.menuTrail.add(new MenuArmEventSnapshot(automationTarget, element, xPath, ctrlDown, altDown, shiftDown, parentMenu));
        }

        @Override
        public void handleEvent(Object event) {
            if (Swt.INJECTED_EVENT_CLASS.isInstance(event)) {
                return;
            }
            int eventType = 0;
            try {
                boolean shiftDown;
                Object widget = Reflection.getPropertyWithReflection(event, "widget", false, null);
                eventType = (Integer)Reflection.getPropertyWithReflection(event, "type", false, 0);
                int stateMask = (Integer)Reflection.getPropertyWithReflection(event, "stateMask", false, 0);
                boolean ctrlDown = (stateMask & 0x40000) != 0;
                boolean altDown = (stateMask & 0x10000) != 0;
                boolean bl = shiftDown = (stateMask & 0x20000) != 0;
                if (KEY_EVENTS.contains(eventType)) {
                    char character;
                    AutomationTarget automationTarget = AutomatableSwtComponent.automatableFromComponent(widget).getKeyEventTarget();
                    int keyCode = (Integer)Reflection.getPropertyWithReflection(event, "keyCode", false, 0);
                    SwtAutomatableKey swtKey = SwtAutomatableKey.getAutomableKey(keyCode, character = ((Character)Reflection.getPropertyWithReflection(event, "character", false, 0)).charValue());
                    AutomatableKey key = swtKey != null ? swtKey.toAutomatableKey() : null;
                    AutomationElement element = this.getElementFromAutomatable(automationTarget.getAutomatable());
                    String xPath = this.xPathFromAutomationElement(element);
                    this.newEvent(automationTarget, element, xPath, null, key, ctrlDown, altDown, shiftDown);
                } else if (MOUSE_EVENTS.contains(eventType)) {
                    AutomatableSwtComponent eventSource = AutomatableSwtComponent.automatableFromComponent(widget);
                    int x = (Integer)Reflection.getPropertyWithReflection(event, "x", false, 0);
                    int y = (Integer)Reflection.getPropertyWithReflection(event, "y", false, 0);
                    AutomationTarget automationTarget = eventSource.getClickEventTarget(new Point(x, y));
                    AutomatableClick clickType = null;
                    if (eventType == 8) {
                        clickType = AutomatableClick.DOUBLE_CLICK;
                    } else {
                        int button = (Integer)Reflection.getPropertyWithReflection(event, "button", false, 0);
                        switch (button) {
                            default: {
                                clickType = AutomatableClick.LEFT;
                                break;
                            }
                            case 2: {
                                clickType = AutomatableClick.MIDDLE;
                                break;
                            }
                            case 3: {
                                clickType = AutomatableClick.RIGHT;
                            }
                        }
                    }
                    AutomationElement element = this.getElementFromAutomatable(automationTarget.getAutomatable());
                    String xPath = this.xPathFromAutomationElement(element);
                    this.newEvent(automationTarget, element, xPath, clickType, null, ctrlDown, altDown, shiftDown);
                } else if (eventType == 30) {
                    int x = (Integer)Reflection.getPropertyWithReflection(event, "x", false, 0);
                    int y = (Integer)Reflection.getPropertyWithReflection(event, "y", false, 0);
                    if (Swt.MENU_ITEM_CLASS.isInstance(widget)) {
                        this.menuItemArmed(widget, x, y, ctrlDown, altDown, shiftDown);
                    }
                } else if (eventType == 13) {
                    if (Swt.MENU_ITEM_CLASS.isInstance(widget)) {
                        for (MenuArmEventSnapshot menuEntry : this.menuTrail) {
                            this.newEvent(menuEntry.automationTarget, menuEntry.element, menuEntry.xpath, AutomatableClick.LEFT, null, menuEntry.ctrlDown, menuEntry.altDown, menuEntry.shiftDown);
                        }
                    } else if (Swt.COMBO_CLASS.isInstance(widget)) {
                        AutomatableComboBoxEntry entry;
                        AutomatableComboBox comboBox = new AutomatableComboBox(widget, null);
                        Integer selectionIndex = (Integer)Reflection.safeCall(widget, "getSelectionIndex", new Object[0]);
                        AutomatableComboBoxEntry automatableComboBoxEntry = entry = selectionIndex != null ? comboBox.getComboxBoxEntry(selectionIndex) : null;
                        if (entry != null) {
                            AutomationTarget automationTarget = new AutomationTarget(entry, 0, 0);
                            AutomationElement element = this.getElementFromAutomatable(automationTarget.getAutomatable());
                            String xPath = this.xPathFromAutomationElement(element);
                            this.newEvent(automationTarget, element, xPath, AutomatableClick.LEFT, null, ctrlDown, altDown, shiftDown);
                        }
                    } else {
                        return;
                    }
                }
                if (eventType != 30) {
                    this.menuTrail.clear();
                }
            }
            catch (Exception e) {
                RemoteLogger.error(e);
            }
        }

        private static class MenuArmEventSnapshot {
            final AutomationTarget automationTarget;
            final AutomationElement element;
            final String xpath;
            final boolean ctrlDown;
            final boolean altDown;
            final boolean shiftDown;
            final Object parentMenu;

            public MenuArmEventSnapshot(AutomationTarget automationTarget, AutomationElement element, String xpath, boolean ctrlDown, boolean altDown, boolean shiftDown, Object parentMenu) {
                this.automationTarget = automationTarget;
                this.element = element;
                this.xpath = xpath;
                this.altDown = altDown;
                this.ctrlDown = ctrlDown;
                this.shiftDown = shiftDown;
                this.parentMenu = parentMenu;
            }
        }
    }
}

