/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.swt;

import java.awt.im.InputContext;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.ibboost.orqa.automation.events.enums.AutomatableKey;

public enum SwtAutomatableKey {
    ENTER("Enter", '\r', 13),
    BACKSPACE("Backspace", '\b', 8),
    TAB("Tab", '\t', 9),
    ESCAPE("Escape", '\u001b', 27),
    SPACE("Space", ' ', 32),
    EXCLAMATION_MARK('!'),
    DOUBLE_QUOTE('\"'),
    HASH('#'),
    DOLLAR('$'),
    PERCENT('%'),
    AMPERSAND('&'),
    SINGLE_QUOTE('\''),
    LEFT_PARENTHESIS('('),
    RIGHT_PARENTHESIS(')'),
    ASTERISK('*'),
    PLUS('+'),
    COMMA(','),
    MINUS('-'),
    PERIOD('.'),
    SLASH('/'),
    ZERO('0'),
    ONE('1'),
    TWO('2'),
    THREE('3'),
    FOUR('4'),
    FIVE('5'),
    SIX('6'),
    SEVEN('7'),
    EIGHT('8'),
    NINE('9'),
    COLON(':'),
    SEMI_COLON(';'),
    LESS_THAN('<'),
    EQUALS('='),
    GREATER_THAN('>'),
    QUESTION_MARK('?'),
    AT('@'),
    A('a'),
    B('b'),
    C('c'),
    D('d'),
    E('e'),
    F('f'),
    G('g'),
    H('h'),
    I('i'),
    J('j'),
    K('k'),
    L('l'),
    M('m'),
    N('n'),
    O('o'),
    P('p'),
    Q('q'),
    R('r'),
    S('s'),
    T('t'),
    U('u'),
    V('v'),
    W('w'),
    X('x'),
    Y('y'),
    Z('z'),
    LEFT_BRACKET('['),
    BACKSLASH('\\'),
    RIGHT_BRACKET(']'),
    CIRCUMFLEX('^'),
    UNDERSCORE('_'),
    BACK_QUOTE('`'),
    LEFT_BRACE('{'),
    VERTICAL_BAR('|'),
    RIGHT_BRACE('}'),
    TILDE('~'),
    INSERT("Insert", 0x1000009),
    DELETE("Delete", '\u007f', 127),
    PAGE_UP("Page up", 0x1000005),
    PAGE_DOWN("Page down", 0x1000006),
    END("End", 0x1000008),
    HOME("Home", 0x1000007),
    PRINT_SCREEN("Print Screen", 16777303),
    LEFT_ARROW("Left arrow", 0x1000003),
    RIGHT_ARROW("Right arrow", 0x1000004),
    UP_ARROW("Up arrow", 0x1000001),
    DOWN_ARROW("Down arrow", 0x1000002),
    NUMPAD_ZERO("Numpad 0", '0', 0x1000030),
    NUMPAD_ONE("Numpad 1", '1', 0x1000031),
    NUMPAD_TWO("Numpad 2", '2', 16777266),
    NUMPAD_THREE("Numpad 3", '3', 0x1000033),
    NUMPAD_FOUR("Numpad 4", '4', 16777268),
    NUMPAD_FIVE("Numpad 5", '5', 16777269),
    NUMPAD_SIX("Numpad 6", '6', 16777270),
    NUMPAD_SEVEN("Numpad 7", '7', 16777271),
    NUMPAD_EIGHT("Numpad 8", '8', 16777272),
    NUMPAD_NINE("Numpad 9", '9', 16777273),
    F1("F1", 0x100000A),
    F2("F2", 0x100000B),
    F3("F3", 0x100000C),
    F4("F4", 0x100000D),
    F5("F5", 0x100000E),
    F6("F6", 0x100000F),
    F7("F7", 0x1000010),
    F8("F8", 0x1000011),
    F9("F9", 0x1000012),
    F10("F10", 0x1000013),
    F11("F11", 0x1000014),
    F12("F12", 0x1000015);

    private static final String DEFAULT_LAYOUT = "EN_US";
    private static final Map<String, Map<SwtAutomatableKey, KeyCombo>> KEY_COMBO_MAPS;
    private static final Map<SwtAutomatableKey, KeyCombo> EN_US_KEY_COMBOS;
    private static final Map<SwtAutomatableKey, KeyCombo> EN_GB_KEY_COMBOS;
    private final String readableName;
    private final char keyChar;
    private final int keyCode;

    public static SwtAutomatableKey getAutomableKey(int keyCode, char keyChar) {
        keyChar = Character.toLowerCase(keyChar);
        if (keyCode != 0) {
            for (SwtAutomatableKey key : SwtAutomatableKey.values()) {
                if (key.getKeyCode() != keyCode) continue;
                return key;
            }
        }
        if (keyChar != '\u0000') {
            for (SwtAutomatableKey key : SwtAutomatableKey.values()) {
                if (key.getKeyChar() != keyChar) continue;
                return key;
            }
        }
        return null;
    }

    private SwtAutomatableKey(char keyChar, int keyCode) {
        this(String.valueOf(keyChar).toUpperCase(), keyChar, keyCode);
    }

    private SwtAutomatableKey(char keyChar) {
        this(String.valueOf(keyChar).toUpperCase(), keyChar, 0);
    }

    private SwtAutomatableKey(String readableName, int keyCode) {
        this(readableName, '\u0000', keyCode);
    }

    private SwtAutomatableKey(String readableName, char keyChar, int keyCode) {
        this.readableName = readableName;
        this.keyChar = keyChar;
        this.keyCode = keyCode;
    }

    public AutomatableKey toAutomatableKey() {
        return AutomatableKey.valueOf(this.name());
    }

    public static SwtAutomatableKey fromAutomatableKey(AutomatableKey key) {
        return SwtAutomatableKey.valueOf(key.name());
    }

    public String toString() {
        return this.readableName;
    }

    public char getKeyChar() {
        return this.keyChar;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public KeyCombo getKeyCombo() {
        Locale locale = InputContext.getInstance().getLocale();
        String localeString = locale != null ? locale.toString().toUpperCase() : null;
        Map<SwtAutomatableKey, KeyCombo> keyCombos = KEY_COMBO_MAPS.get(localeString);
        if (keyCombos == null) {
            keyCombos = KEY_COMBO_MAPS.get(DEFAULT_LAYOUT);
        }
        KeyCombo result = null;
        if (keyCombos != null) {
            result = keyCombos.get((Object)this);
        }
        if (result == null) {
            result = new KeyCombo(this.keyCode, this.keyChar, false, false, false);
        }
        return result;
    }

    static {
        KEY_COMBO_MAPS = new HashMap<String, Map<SwtAutomatableKey, KeyCombo>>();
        EN_US_KEY_COMBOS = new HashMap<SwtAutomatableKey, KeyCombo>();
        EN_GB_KEY_COMBOS = new HashMap<SwtAutomatableKey, KeyCombo>();
        KEY_COMBO_MAPS.put(DEFAULT_LAYOUT, EN_US_KEY_COMBOS);
        KEY_COMBO_MAPS.put("EN_GB", EN_GB_KEY_COMBOS);
        EN_US_KEY_COMBOS.put(EXCLAMATION_MARK, new KeyCombo(0, '1', true, false, false));
        EN_US_KEY_COMBOS.put(DOUBLE_QUOTE, new KeyCombo(0, '\'', true, false, false));
        EN_US_KEY_COMBOS.put(HASH, new KeyCombo(0, '3', true, false, false));
        EN_US_KEY_COMBOS.put(DOLLAR, new KeyCombo(0, '4', true, false, false));
        EN_US_KEY_COMBOS.put(PERCENT, new KeyCombo(0, '5', true, false, false));
        EN_US_KEY_COMBOS.put(AMPERSAND, new KeyCombo(0, '7', true, false, false));
        EN_US_KEY_COMBOS.put(LEFT_PARENTHESIS, new KeyCombo(0, '9', true, false, false));
        EN_US_KEY_COMBOS.put(RIGHT_PARENTHESIS, new KeyCombo(0, '0', true, false, false));
        EN_US_KEY_COMBOS.put(ASTERISK, new KeyCombo(0, '8', true, false, false));
        EN_US_KEY_COMBOS.put(PLUS, new KeyCombo(0, '=', true, false, false));
        EN_US_KEY_COMBOS.put(COLON, new KeyCombo(0, ';', true, false, false));
        EN_US_KEY_COMBOS.put(LESS_THAN, new KeyCombo(0, ',', true, false, false));
        EN_US_KEY_COMBOS.put(GREATER_THAN, new KeyCombo(0, '.', true, false, false));
        EN_US_KEY_COMBOS.put(QUESTION_MARK, new KeyCombo(0, '/', true, false, false));
        EN_US_KEY_COMBOS.put(AT, new KeyCombo(0, '2', true, false, false));
        EN_US_KEY_COMBOS.put(CIRCUMFLEX, new KeyCombo(0, '6', true, false, false));
        EN_US_KEY_COMBOS.put(UNDERSCORE, new KeyCombo(0, '-', true, false, false));
        EN_US_KEY_COMBOS.put(LEFT_BRACE, new KeyCombo(0, '[', true, false, false));
        EN_US_KEY_COMBOS.put(VERTICAL_BAR, new KeyCombo(0, '\\', true, false, false));
        EN_US_KEY_COMBOS.put(RIGHT_BRACE, new KeyCombo(0, ']', true, false, false));
        EN_US_KEY_COMBOS.put(TILDE, new KeyCombo(0, '`', true, false, false));
        EN_GB_KEY_COMBOS.put(EXCLAMATION_MARK, new KeyCombo(0, '1', true, false, false));
        EN_GB_KEY_COMBOS.put(DOUBLE_QUOTE, new KeyCombo(0, '2', true, false, false));
        EN_GB_KEY_COMBOS.put(DOLLAR, new KeyCombo(0, '4', true, false, false));
        EN_GB_KEY_COMBOS.put(PERCENT, new KeyCombo(0, '5', true, false, false));
        EN_GB_KEY_COMBOS.put(AMPERSAND, new KeyCombo(0, '7', true, false, false));
        EN_GB_KEY_COMBOS.put(LEFT_PARENTHESIS, new KeyCombo(0, '9', true, false, false));
        EN_GB_KEY_COMBOS.put(RIGHT_PARENTHESIS, new KeyCombo(0, '0', true, false, false));
        EN_GB_KEY_COMBOS.put(ASTERISK, new KeyCombo(0, '8', true, false, false));
        EN_GB_KEY_COMBOS.put(PLUS, new KeyCombo(0, '=', true, false, false));
        EN_GB_KEY_COMBOS.put(COLON, new KeyCombo(0, ';', true, false, false));
        EN_GB_KEY_COMBOS.put(LESS_THAN, new KeyCombo(0, ',', true, false, false));
        EN_GB_KEY_COMBOS.put(GREATER_THAN, new KeyCombo(0, '.', true, false, false));
        EN_GB_KEY_COMBOS.put(QUESTION_MARK, new KeyCombo(0, '/', true, false, false));
        EN_GB_KEY_COMBOS.put(AT, new KeyCombo(0, '\'', true, false, false));
        EN_GB_KEY_COMBOS.put(CIRCUMFLEX, new KeyCombo(0, '6', true, false, false));
        EN_GB_KEY_COMBOS.put(UNDERSCORE, new KeyCombo(0, '-', true, false, false));
        EN_GB_KEY_COMBOS.put(LEFT_BRACE, new KeyCombo(0, '[', true, false, false));
        EN_GB_KEY_COMBOS.put(VERTICAL_BAR, new KeyCombo(0, '\\', true, false, false));
        EN_GB_KEY_COMBOS.put(RIGHT_BRACE, new KeyCombo(0, ']', true, false, false));
        EN_GB_KEY_COMBOS.put(TILDE, new KeyCombo(0, '#', true, false, false));
    }

    public static final class KeyCombo {
        private final int keyCode;
        private final char keyChar;
        private final boolean shift;
        private final boolean alt;
        private final boolean ctrl;

        public KeyCombo(int keyCode, char keyChar, boolean shift, boolean alt, boolean ctrl) {
            this.keyCode = keyCode;
            this.keyChar = keyChar;
            this.shift = shift;
            this.alt = alt;
            this.ctrl = ctrl;
        }

        public int getKeyCode() {
            return this.keyCode;
        }

        public char getKeyChar() {
            return this.keyChar;
        }

        public boolean isShift() {
            return this.shift;
        }

        public boolean isAlt() {
            return this.alt;
        }

        public boolean isCtrl() {
            return this.ctrl;
        }
    }
}

