/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.swt;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.proxy.AutomationTarget;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableSwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableTreeNode;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.Swt;

public class AutomatableTree
extends AutomatableSwtComponent {
    public AutomatableTree(Object component, AutomatableSwtComponent parent) {
        super(component, parent);
    }

    @Override
    protected AutomatableSwtComponent getChildFromItem(Object treeItem, int itemIndex) {
        if (Swt.TREE_ITEM_CLASS.isInstance(treeItem)) {
            return new AutomatableTreeNode(this.component, treeItem, this);
        }
        return AutomatableSwtComponent.automatableFromComponent(treeItem, this);
    }

    protected static Object getTreeItemParent(final Object treeItem) throws JavaAppException {
        return AutomatableTree.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Object result = Reflection.safeCall(treeItem, "getParentItem", new Object[0]);
                if (result == null) {
                    result = Reflection.safeCall(treeItem, "getParent", new Object[0]);
                }
                return result;
            }
        });
    }

    protected List<Object> getTreeItemPath(Object treeItem) throws JavaAppException {
        LinkedList<Object> path = new LinkedList<Object>();
        Object current = treeItem;
        while (Swt.TREE_ITEM_CLASS.isInstance(current)) {
            path.add(0, current);
            current = AutomatableTree.getTreeItemParent(current);
        }
        return path;
    }

    @Override
    public AutomationTarget getKeyEventTarget() throws JavaAppException {
        return AutomatableTree.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                Object[] selection = (Object[])Reflection.safeCall(AutomatableTree.this.component, "getSelection", new Object[0]);
                if (selection.length > 0 && Swt.TREE_ITEM_CLASS.isInstance(selection[0])) {
                    List<Object> treeItemPath = AutomatableTree.this.getTreeItemPath(selection[0]);
                    AutomatableTree node = AutomatableTree.this;
                    for (Object treeItem : treeItemPath) {
                        node = new AutomatableTreeNode(AutomatableTree.this.component, treeItem, node);
                    }
                    return new AutomationTarget(node);
                }
                return new AutomationTarget(AutomatableTree.this);
            }
        });
    }

    @Override
    public AutomationTarget getClickEventTarget(final Point clickOffset) throws JavaAppException {
        return AutomatableTree.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                Object targetItem = Reflection.safeCall(AutomatableTree.this.component, "getItem", Swt.POINT_CLASS, Swt.newPoint(clickOffset.x, clickOffset.y));
                if (targetItem != null) {
                    List<Object> treeItemPath = AutomatableTree.this.getTreeItemPath(targetItem);
                    AutomatableTree node = AutomatableTree.this;
                    for (Object treeItem : treeItemPath) {
                        node = new AutomatableTreeNode(AutomatableTree.this.component, treeItem, node);
                    }
                    Rectangle nodeBounds = node.getComponentRelativeBounds();
                    return new AutomationTarget(node, clickOffset.x - nodeBounds.x, clickOffset.y - nodeBounds.y);
                }
                return new AutomationTarget(AutomatableTree.this, clickOffset.x, clickOffset.y);
            }
        });
    }
}

