/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.swt;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableSwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableTable;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableTableHeaderCell;

public class AutomatableTableHeader
extends AutomatableTable {
    private static final String XNODE_NAME = "HeaderRow";

    public AutomatableTableHeader(Object table, AutomatableSwtComponent parent) {
        super(table, parent);
    }

    @Override
    public List<AutomatableSwtComponent> getChildren() throws JavaAppException {
        return AutomatableTableHeader.uiSafeExecute(new Callable<List<AutomatableSwtComponent>>(){

            @Override
            public List<AutomatableSwtComponent> call() throws Exception {
                ArrayList<AutomatableSwtComponent> children = new ArrayList<AutomatableSwtComponent>();
                try {
                    Object[] columns = (Object[])Reflection.safeCall(AutomatableTableHeader.this.component, "getColumns", new Object[0]);
                    if (columns != null) {
                        for (int i = 0; i < columns.length; ++i) {
                            children.add(new AutomatableTableHeaderCell(AutomatableTableHeader.this.component, AutomatableTableHeader.this, columns[i], i));
                        }
                    }
                }
                catch (Exception e) {
                    RemoteLogger.error(e);
                }
                return children;
            }
        });
    }

    AutomatableTableHeaderCell getChild(final int columnIndex) throws JavaAppException {
        return AutomatableTableHeader.uiSafeExecute(new Callable<AutomatableTableHeaderCell>(){

            @Override
            public AutomatableTableHeaderCell call() throws Exception {
                Object column = Reflection.safeCall(AutomatableTableHeader.this.component, "getColumn", Integer.TYPE, columnIndex);
                return new AutomatableTableHeaderCell(AutomatableTableHeader.this.component, AutomatableTableHeader.this, column, columnIndex);
            }
        });
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return AutomatableTableHeader.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Rectangle widthAndXOffset = AutomatableTableHeader.this.getRowWidthAndXOffset();
                int height = (Integer)Reflection.safeCall(AutomatableTableHeader.this.component, "getHeaderHeight", new Object[0]);
                return new Rectangle(widthAndXOffset.x, 0, widthAndXOffset.width, height);
            }
        });
    }

    @Override
    public String getName() {
        return XNODE_NAME;
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableTableHeader.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                List<AutomatableSwtComponent> children = AutomatableTableHeader.this.getChildren();
                ArrayList<Object> results = new ArrayList<Object>();
                for (AutomatableSwtComponent child : children) {
                    results.add(child.getValue());
                }
                return results;
            }
        });
    }
}

