/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.swt;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.AutomationTarget;
import org.ibboost.orqa.automation.java.proxy.automatable.Automatable;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableSwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableTableHeader;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.AutomatableTableRow;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.Swt;

public class AutomatableTable
extends AutomatableSwtComponent {
    private static final String ROW_REFERENCE = "/Row";
    private static final String CELL_REFERENCE = "/Cell";
    private static final Pattern ROW_PATTERN = Pattern.compile("/Row\\[([0-9]+)\\]");
    private static ThreadLocal<Integer> maxRowCount = new ThreadLocal();

    public AutomatableTable(Object table, AutomatableSwtComponent parent) {
        super(table, parent);
    }

    public static void optimiseForTarget(String target) {
        if (!target.contains(ROW_REFERENCE) && !target.contains(CELL_REFERENCE)) {
            maxRowCount.set(0);
        } else {
            Matcher rowMatcher = ROW_PATTERN.matcher(target);
            if (rowMatcher.find()) {
                int rowIndex = Integer.valueOf(rowMatcher.group(1));
                while (rowMatcher.find()) {
                    rowIndex = Math.max(rowIndex, Integer.valueOf(rowMatcher.group(1)));
                }
                maxRowCount.set(rowIndex);
            }
        }
    }

    public static void resetOptimisation() {
        maxRowCount.remove();
    }

    @Override
    public List<AutomatableSwtComponent> getChildren() throws JavaAppException {
        return AutomatableTable.uiSafeExecute(new Callable<List<AutomatableSwtComponent>>(){

            @Override
            public List<AutomatableSwtComponent> call() throws Exception {
                Object children;
                ArrayList<AutomatableSwtComponent> result = new ArrayList<AutomatableSwtComponent>();
                if (Swt.COMPOSITE_CLASS.isInstance(AutomatableTable.this.component) && (children = Reflection.safeCall(AutomatableTable.this.component, "getChildren", new Object[0])) instanceof Object[]) {
                    for (Object child : (Object[])children) {
                        result.add(AutomatableSwtComponent.automatableFromComponent(child));
                    }
                }
                result.add(new AutomatableTableHeader(AutomatableTable.this.component, AutomatableTable.this));
                Object[] items = AutomatableTable.this.getItems();
                for (int i = 0; i < items.length && (maxRowCount.get() == null || i < (Integer)maxRowCount.get()); ++i) {
                    if (!Swt.TABLE_ITEM_CLASS.isInstance(items[i])) continue;
                    result.add(new AutomatableTableRow(AutomatableTable.this.component, AutomatableTable.this, items[i], i));
                }
                return result;
            }
        });
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableTable.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ArrayList<List> results = new ArrayList<List>();
                ArrayList<Object> header = new ArrayList<Object>();
                Object[] columns = (Object[])Reflection.safeCall(AutomatableTable.this.component, "getColumns", new Object[0]);
                if (columns != null) {
                    for (Object column : columns) {
                        header.add(Reflection.safeCall(column, "getText", new Object[0]));
                    }
                }
                results.add(header);
                Object[] items = AutomatableTable.this.getItems();
                for (int i = 0; i < items.length; ++i) {
                    if (!Swt.TABLE_ITEM_CLASS.isInstance(items[i])) continue;
                    results.add((List)new AutomatableTableRow(AutomatableTable.this.component, AutomatableTable.this, items[i], i).getValue());
                }
                return results;
            }
        });
    }

    @Override
    public AutomationTarget getKeyEventTarget() throws JavaAppException {
        return AutomatableTable.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                Object[] selection = (Object[])Reflection.safeCall(AutomatableTable.this.component, "getSelection", new Object[0]);
                if (selection != null && selection.length > 0) {
                    Integer selectedRowIndex = (Integer)Reflection.safeCall(AutomatableTable.this.component, "getSelectionIndex", new Object[0]);
                    Object selectedRow = selection[0];
                    if (selectedRowIndex != null) {
                        return new AutomationTarget(new AutomatableTableRow(AutomatableTable.this.component, AutomatableTable.this, selectedRow, selectedRowIndex));
                    }
                }
                return new AutomationTarget(AutomatableTable.this);
            }
        });
    }

    private int getColumnIndexForPoint(Point offset) {
        int itemCount = (Integer)Reflection.safeCall(this.component, "getItemCount", new Object[0]);
        int columnCount = (Integer)Reflection.safeCall(this.component, "getColumnCount", new Object[0]);
        if (itemCount > 0) {
            Object firstRow = Reflection.safeCall(this.component, "getItem", Integer.TYPE, 0);
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                Rectangle columnBounds = Swt.convertBounds(Reflection.safeCall(firstRow, "getBounds", Integer.TYPE, columnIndex));
                if (offset.x > columnBounds.x + columnBounds.width) continue;
                return columnIndex;
            }
        } else {
            int gridLineWidth = (Integer)Reflection.safeCall(this.component, "getGridLineWidth", new Object[0]);
            int currentColumnEnd = 0;
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                Object currentColumn = Reflection.safeCall(this.component, "getColumn", Integer.TYPE, columnIndex);
                if (columnIndex > 0) {
                    currentColumnEnd += gridLineWidth;
                }
                if (offset.x > (currentColumnEnd += ((Integer)Reflection.safeCall(currentColumn, "getWidth", new Object[0])).intValue())) continue;
                return columnIndex;
            }
        }
        return -1;
    }

    @Override
    public AutomationTarget getClickEventTarget(final Point clickOffset) throws JavaAppException {
        return AutomatableTable.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                Automatable targetAutomatable = null;
                try {
                    int columnIndex = AutomatableTable.this.getColumnIndexForPoint(clickOffset);
                    Object row = Reflection.safeCall(AutomatableTable.this.component, "getItem", Swt.POINT_CLASS, Swt.newPoint(clickOffset.x, clickOffset.y));
                    if (row == null) {
                        int gridLineWidth;
                        int headerHeight = (Integer)Reflection.safeCall(AutomatableTable.this.component, "getHeaderHeight", new Object[0]);
                        if (clickOffset.y <= headerHeight + (gridLineWidth = ((Integer)Reflection.safeCall(AutomatableTable.this.component, "getGridLineWidth", new Object[0])).intValue())) {
                            AutomatableTableHeader automatableHeader = new AutomatableTableHeader(AutomatableTable.this.component, AutomatableTable.this);
                            targetAutomatable = columnIndex != -1 ? automatableHeader.getChild(columnIndex) : automatableHeader;
                        }
                    } else {
                        int rowIndex = AutomatableTable.this.getItemIndex(row);
                        if (rowIndex != -1) {
                            AutomatableTableRow automatableRow = new AutomatableTableRow(AutomatableTable.this.component, AutomatableTable.this, row, rowIndex);
                            targetAutomatable = columnIndex != -1 ? automatableRow.getChild(columnIndex) : automatableRow;
                        }
                    }
                }
                catch (Exception e) {
                    RemoteLogger.error(e);
                }
                if (targetAutomatable != null) {
                    Rectangle targetAutomatableBounds = targetAutomatable.getComponentRelativeBounds();
                    return new AutomationTarget(targetAutomatable, clickOffset.x - targetAutomatableBounds.x, clickOffset.y - targetAutomatableBounds.y);
                }
                return new AutomationTarget(AutomatableTable.this, clickOffset.x, clickOffset.y);
            }
        });
    }

    Rectangle getRowWidthAndXOffset() throws JavaAppException {
        return AutomatableTable.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                int itemCount = (Integer)Reflection.safeCall(AutomatableTable.this.component, "getItemCount", new Object[0]);
                int columnCount = (Integer)Reflection.safeCall(AutomatableTable.this.component, "getColumnCount", new Object[0]);
                if (itemCount > 0 && columnCount > 0) {
                    Object firstRow = Reflection.safeCall(AutomatableTable.this.component, "getItem", Integer.TYPE, 0);
                    Rectangle firstCol = Swt.convertBounds(Reflection.safeCall(firstRow, "getBounds", Integer.TYPE, 0));
                    Rectangle lastCol = Swt.convertBounds(Reflection.safeCall(firstRow, "getBounds", Integer.TYPE, columnCount - 1));
                    int width = lastCol.x + lastCol.width - firstCol.x;
                    return new Rectangle(firstCol.x, 0, width, 0);
                }
                int width = 0;
                if (columnCount > 0) {
                    int gridLineWidth = (Integer)Reflection.safeCall(AutomatableTable.this.component, "getGridLineWidth", new Object[0]);
                    for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                        Object currentColumn = Reflection.safeCall(AutomatableTable.this.component, "getColumn", Integer.TYPE, columnIndex);
                        if (columnIndex > 0) {
                            width += gridLineWidth;
                        }
                        width += ((Integer)Reflection.safeCall(currentColumn, "getWidth", new Object[0])).intValue();
                    }
                }
                return new Rectangle(0, 0, width, 0);
            }
        });
    }

    private int getItemIndex(Object tableItem) {
        int index = -1;
        try {
            if (tableItem != null) {
                index = (Integer)Reflection.safeCall(this.component, "indexOf", Swt.TABLE_ITEM_CLASS, tableItem);
            }
        }
        catch (Exception e) {
            RemoteLogger.error(e);
        }
        return index;
    }
}

