/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.ewt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableToolBar;

public class AutomatableToolBarButton
extends AutomatableToolBar {
    private final Object button;
    private final int index;

    public AutomatableToolBarButton(Component toolbar, AutomatableAwtComponent<?> parent, Object button, int index) {
        super(toolbar, parent);
        this.button = button;
        this.index = index;
    }

    @Override
    public String getName() {
        return AutomatableToolBarButton.getXPathNodeNameFromClass(this.button.getClass());
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return AutomatableToolBarButton.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Point location = (Point)Reflection.getPropertyWithReflection(AutomatableToolBarButton.this.button, "location", true, new Point(0, 0));
                Dimension size = (Dimension)Reflection.getPropertyWithReflection(AutomatableToolBarButton.this.button, "size", true, new Dimension(0, 0));
                return new Rectangle(location.x, location.y, size.width, size.height);
            }
        });
    }

    @Override
    public List<AutomatableAwtComponent<?>> getChildren() {
        return new ArrayList();
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableToolBarButton.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return "";
            }
        });
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        return AutomatableToolBarButton.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (name.equals("enabled")) {
                    return ((Boolean)Reflection.getPropertyWithReflection(AutomatableToolBarButton.this.button, "enabled", true, Boolean.TRUE)).toString();
                }
                if (name.equals("selected")) {
                    return ((Boolean)Reflection.getPropertyWithReflection(AutomatableToolBarButton.this.button, "armed", true, Boolean.FALSE)).toString();
                }
                if (name.equals("text")) {
                    String text = (String)Reflection.getPropertyWithReflection(AutomatableToolBarButton.this.button, "label", true, null);
                    if (text == null) {
                        text = (String)Reflection.getPropertyWithReflection(AutomatableToolBarButton.this.button, "helpText", true, "");
                    }
                    return text;
                }
                try {
                    if (name.equals("background")) {
                        return AutomatableAwtComponent.colorToHex((Color)Reflection.getPropertyWithReflection(AutomatableToolBarButton.this.button, "paintBackground", true, null));
                    }
                    if (name.equals("foreground")) {
                        return AutomatableAwtComponent.colorToHex((Color)Reflection.getPropertyWithReflection(AutomatableToolBarButton.this.button, "paintForeground", true, null));
                    }
                }
                catch (Exception e) {
                    RemoteLogger.error(e);
                }
                return AutomatableToolBarButton.super.getAttributeValue(name);
            }
        });
    }

    @Override
    public String[] getAttributeNames() {
        return XATTR_BUTTONS;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof AutomatableToolBarButton)) {
            return false;
        }
        return ((AutomatableToolBarButton)other).index == this.index;
    }

    @Override
    public boolean hasStringValue() {
        return true;
    }
}

