/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.ewt;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableListView;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableListViewRow;

public class AutomatableListViewRowCell
extends AutomatableListView {
    public static final String XNODE_NAME = "Cell";
    private final int rowIndex;
    private final int columnIndex;

    public AutomatableListViewRowCell(Component listView, AutomatableListViewRow parent, int rowIndex, int columnIndex) {
        super(listView, (AutomatableAwtComponent<?>)parent);
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
    }

    @Override
    public List<AutomatableAwtComponent<?>> getChildren() {
        return new ArrayList();
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return this.getCellBounds(this.rowIndex, this.columnIndex);
    }

    @Override
    public void getFocus() throws JavaAppException {
        AutomatableListViewRowCell.assertNotUIThread();
        AutomatableListViewRowCell.getComponentFocus(this.component);
        this.select(true);
    }

    @Override
    public void select(boolean replace) throws JavaAppException {
        AutomatableListViewRowCell.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Reflection.call(AutomatableListViewRowCell.this.component, "setSelectedRow", Integer.TYPE, AutomatableListViewRowCell.this.rowIndex);
                return null;
            }
        });
    }

    @Override
    public String getName() {
        return XNODE_NAME;
    }

    @Override
    public String[] getAttributeNames() {
        return XATTR_INDEX_POSITION_SIZE_COLORS;
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        return AutomatableListViewRowCell.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (name.equals("index")) {
                    return Integer.toString(AutomatableListViewRowCell.this.columnIndex + 1);
                }
                return AutomatableListViewRowCell.super.getAttributeValue(name);
            }
        });
    }

    @Override
    public void setTextValue(final String text, final boolean append) throws JavaAppException {
        AutomatableListViewRowCell.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    Object oldValue;
                    Object mDataSource = Reflection.getPropertyWithReflection(AutomatableListViewRowCell.this.component, "mDataSource", false, null);
                    String newText = text;
                    if (append && (oldValue = Reflection.safeCall(AutomatableListViewRowCell.this.component, "getCellData", Integer.TYPE, AutomatableListViewRowCell.this.columnIndex, Integer.TYPE, AutomatableListViewRowCell.this.rowIndex)) != null && !oldValue.toString().isEmpty()) {
                        newText = oldValue.toString() + text;
                    }
                    Reflection.call(mDataSource, "setData", Integer.TYPE, AutomatableListViewRowCell.this.columnIndex, Integer.TYPE, AutomatableListViewRowCell.this.rowIndex, Object.class, newText);
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException();
                }
                return null;
            }
        });
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableListViewRowCell.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return Reflection.safeCall(AutomatableListViewRowCell.this.component, "getCellData", Integer.TYPE, AutomatableListViewRowCell.this.columnIndex, Integer.TYPE, AutomatableListViewRowCell.this.rowIndex);
            }
        });
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof AutomatableListViewRowCell)) {
            return false;
        }
        return ((AutomatableListViewRowCell)other).rowIndex == this.rowIndex && ((AutomatableListViewRowCell)other).columnIndex == this.columnIndex;
    }

    @Override
    public boolean isTextCurrentlyEditable() throws JavaAppException {
        return false;
    }

    @Override
    public boolean hasStringValue() {
        return true;
    }
}

